"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterActivity = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MyEuiFilterGroup = (0, _styledComponents.default)(_eui.EuiFilterGroup)`
  > .euiFilterButton-hasNotification {
    min-width: 68px;
  }
`;
const FilterAllButton = (0, _styledComponents.default)(_eui.EuiFilterButton)`
  &,
  & .euiFilterButton__textShift {
    min-width: 28px;
  }
`;
const FilterActivity = /*#__PURE__*/_react.default.memo(({
  type,
  onFilterChange,
  userActionsStats,
  isLoading = false
}) => {
  const handleFilterChange = (0, _react.useCallback)(value => {
    if (value !== type) {
      onFilterChange(value);
    }
  }, [onFilterChange, type]);
  return /*#__PURE__*/_react.default.createElement(MyEuiFilterGroup, {
    "data-test-subj": "user-actions-filter-activity-group"
  }, /*#__PURE__*/_react.default.createElement(FilterAllButton, {
    withNext: true,
    grow: false,
    onClick: () => handleFilterChange('all'),
    hasActiveFilters: type === 'all',
    numFilters: userActionsStats && userActionsStats.total > 0 ? userActionsStats.total : 0,
    isLoading: isLoading,
    isDisabled: isLoading,
    "data-test-subj": "user-actions-filter-activity-button-all",
    iconSize: "s"
  }, i18n.ALL), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    withNext: true,
    grow: false,
    hasActiveFilters: type === 'user',
    numFilters: userActionsStats && userActionsStats.totalComments > 0 ? userActionsStats.totalComments : 0,
    isLoading: isLoading,
    isDisabled: isLoading,
    onClick: () => handleFilterChange('user'),
    "data-test-subj": "user-actions-filter-activity-button-comments"
  }, i18n.COMMENTS), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    hasActiveFilters: type === 'action',
    numFilters: userActionsStats && userActionsStats.totalOtherActions > 0 ? userActionsStats.totalOtherActions : 0,
    onClick: () => handleFilterChange('action'),
    isLoading: isLoading,
    isDisabled: isLoading,
    "data-test-subj": "user-actions-filter-activity-button-history"
  }, i18n.HISTORY));
});
exports.FilterActivity = FilterActivity;
FilterActivity.displayName = 'FilterActivity';