"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserActionsList = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _helpers = require("./helpers");
var _use_cases_context = require("../cases_context/use_cases_context");
var _builder = require("./builder");
var _navigation = require("../../common/navigation");
var _use_user_actions_handler = require("./use_user_actions_handler");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MyEuiCommentList = (0, _styledComponents.default)(_eui.EuiCommentList)`
  ${({
  theme
}) => `
    & .userAction__comment.outlined .euiCommentEvent {
      outline: solid 5px ${theme.eui.euiColorVis1_behindText};
      margin: 0.5em;
      transition: 0.8s;
    }

    & .draftFooter {
      & .euiCommentEvent__body {
        padding: 0;
      }
    }

    & .euiComment.isEdit {
      & .euiCommentEvent {
        border: none;
        box-shadow: none;
      }

      & .euiCommentEvent__body {
        padding: 0;
      }

      & .euiCommentEvent__header {
        display: none;
      }
    }

    & .comment-action.empty-comment [class*="euiCommentEvent-regular"] {
      box-shadow: none;
      .euiCommentEvent__header {
        padding: ${theme.eui.euiSizeM} ${theme.eui.euiSizeS};
        border-bottom: 0;
      }
    }
  `}
`;
const UserActionsList = /*#__PURE__*/_react.default.memo(({
  caseUserActions,
  caseConnectors,
  userProfiles,
  currentUserProfile,
  data: caseData,
  casesConfiguration,
  getRuleDetailsHref,
  actionsNavigation,
  onRuleDetailsClick,
  onShowAlertDetails,
  loadingAlertData,
  manualAlertsData,
  commentRefs,
  handleManageQuote,
  bottomActions = [],
  isExpandable = false
}) => {
  const {
    externalReferenceAttachmentTypeRegistry,
    persistableStateAttachmentTypeRegistry,
    appId
  } = (0, _use_cases_context.useCasesContext)();
  const {
    commentId
  } = (0, _navigation.useCaseViewParams)();
  const [initLoading, setInitLoading] = (0, _react.useState)(true);
  const {
    loadingCommentIds,
    selectedOutlineCommentId,
    manageMarkdownEditIds,
    handleManageMarkdownEditId,
    handleOutlineComment,
    handleSaveComment,
    handleDeleteComment
  } = (0, _use_user_actions_handler.useUserActionsHandler)();
  const builtUserActions = (0, _react.useMemo)(() => {
    if (!caseUserActions) {
      return [];
    }
    return caseUserActions.reduce((comments, userAction, index) => {
      if (!(0, _helpers.isUserActionTypeSupported)(userAction.type)) {
        return comments;
      }
      const builder = _builder.builderMap[userAction.type];
      if (builder == null) {
        return comments;
      }
      const userActionBuilder = builder({
        appId,
        caseData,
        casesConfiguration,
        caseConnectors,
        externalReferenceAttachmentTypeRegistry,
        persistableStateAttachmentTypeRegistry,
        userAction,
        userProfiles,
        currentUserProfile,
        comments: caseData === null || caseData === void 0 ? void 0 : caseData.comments,
        index,
        commentRefs,
        manageMarkdownEditIds,
        selectedOutlineCommentId,
        loadingCommentIds,
        loadingAlertData,
        alertData: manualAlertsData,
        handleOutlineComment,
        handleManageMarkdownEditId,
        handleDeleteComment,
        handleSaveComment,
        handleManageQuote,
        onShowAlertDetails,
        actionsNavigation,
        getRuleDetailsHref,
        onRuleDetailsClick
      });
      return [...comments, ...userActionBuilder.build()];
    }, []);
  }, [caseUserActions, appId, caseData, casesConfiguration, caseConnectors, externalReferenceAttachmentTypeRegistry, persistableStateAttachmentTypeRegistry, userProfiles, currentUserProfile, commentRefs, manageMarkdownEditIds, selectedOutlineCommentId, loadingCommentIds, loadingAlertData, manualAlertsData, handleOutlineComment, handleManageMarkdownEditId, handleDeleteComment, handleSaveComment, handleManageQuote, onShowAlertDetails, actionsNavigation, getRuleDetailsHref, onRuleDetailsClick]);
  const comments = bottomActions !== null && bottomActions !== void 0 && bottomActions.length ? [...builtUserActions, ...bottomActions] : [...builtUserActions];
  (0, _react.useEffect)(() => {
    if (commentId != null && initLoading) {
      setInitLoading(false);
      handleOutlineComment(commentId);
    }
  }, [commentId, initLoading, handleOutlineComment]);
  return /*#__PURE__*/_react.default.createElement(MyEuiCommentList, {
    className: isExpandable ? 'commentList--hasShowMore' : '',
    comments: comments,
    "data-test-subj": "user-actions-list"
  });
});
exports.UserActionsList = UserActionsList;
UserActionsList.displayName = 'UserActionsList';