"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostIsolationCommentEvent = void 0;
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("../translations"));
var _links = require("../../links");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HostIsolationCommentEventComponent = ({
  type,
  endpoints,
  href,
  onClick
}) => {
  const endpointDetailsHref = href ? href(endpoints[0].endpointId) : '';
  const onLinkClick = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    if (onClick) onClick(endpoints[0].endpointId, ev);
  }, [onClick, endpoints]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, type === 'isolate' ? `${i18n.ISOLATED_HOST} ` : `${i18n.RELEASED_HOST} `, /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
    onClick: onLinkClick,
    href: endpointDetailsHref,
    "data-test-subj": `actions-link-${endpoints[0].endpointId}`
  }, endpoints[0].hostname), endpoints.length > 1 && i18n.OTHER_ENDPOINTS(endpoints.length - 1));
};
HostIsolationCommentEventComponent.displayName = 'HostIsolationCommentEvent';
const HostIsolationCommentEvent = /*#__PURE__*/(0, _react.memo)(HostIsolationCommentEventComponent);
exports.HostIsolationCommentEvent = HostIsolationCommentEvent;