"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createExternalReferenceAttachmentUserActionBuilder = void 0;
var _registered_attachments = require("./registered_attachments");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createExternalReferenceAttachmentUserActionBuilder = ({
  userAction,
  userProfiles,
  comment,
  externalReferenceAttachmentTypeRegistry,
  caseData,
  isLoading,
  handleDeleteComment
}) => {
  return (0, _registered_attachments.createRegisteredAttachmentUserActionBuilder)({
    userAction,
    userProfiles,
    comment,
    registry: externalReferenceAttachmentTypeRegistry,
    caseData,
    handleDeleteComment,
    isLoading,
    getId: () => comment.externalReferenceAttachmentTypeId,
    getAttachmentViewProps: () => ({
      externalReferenceId: comment.externalReferenceId,
      externalReferenceMetadata: comment.externalReferenceMetadata
    })
  });
};
exports.createExternalReferenceAttachmentUserActionBuilder = createExternalReferenceAttachmentUserActionBuilder;