"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCommentUserActionBuilder = void 0;
var _domain = require("../../../../common/types/domain");
var _common = require("../common");
var i18n = _interopRequireWildcard(require("./translations"));
var _user = require("./user");
var _alert = require("./alert");
var _actions = require("./actions");
var _external_reference = require("./external_reference");
var _persistable_state = require("./persistable_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUpdateLabelTitle = () => `${i18n.EDITED_FIELD} ${i18n.COMMENT.toLowerCase()}`;
const getDeleteLabelTitle = ({
  userAction,
  caseData,
  externalReferenceAttachmentTypeRegistry,
  persistableStateAttachmentTypeRegistry
}) => {
  const {
    comment
  } = userAction.payload;
  if (comment.type === _domain.AttachmentType.alert) {
    const totalAlerts = Array.isArray(comment.alertId) ? comment.alertId.length : 1;
    const alertLabel = i18n.MULTIPLE_ALERTS(totalAlerts);
    return `${i18n.REMOVED_FIELD} ${alertLabel}`;
  }
  if (comment.type === _domain.AttachmentType.externalReference) {
    return getDeleteLabelFromRegistry({
      caseData,
      registry: externalReferenceAttachmentTypeRegistry,
      getId: () => comment.externalReferenceAttachmentTypeId,
      getAttachmentProps: () => ({
        externalReferenceId: comment.externalReferenceId,
        externalReferenceMetadata: comment.externalReferenceMetadata
      })
    });
  }
  if (comment.type === _domain.AttachmentType.persistableState) {
    return getDeleteLabelFromRegistry({
      caseData,
      registry: persistableStateAttachmentTypeRegistry,
      getId: () => comment.persistableStateAttachmentTypeId,
      getAttachmentProps: () => ({
        persistableStateAttachmentTypeId: comment.persistableStateAttachmentTypeId,
        persistableStateAttachmentState: comment.persistableStateAttachmentState
      })
    });
  }
  return `${i18n.REMOVED_FIELD} ${i18n.COMMENT.toLowerCase()}`;
};
const getDeleteLabelFromRegistry = ({
  caseData,
  registry,
  getId,
  getAttachmentProps
}) => {
  var _attachmentType$getAt, _attachmentType$getAt2;
  const registeredAttachmentCommonLabel = `${i18n.REMOVED_FIELD} ${i18n.ATTACHMENT.toLowerCase()}`;
  const attachmentTypeId = getId();
  const isTypeRegistered = registry.has(attachmentTypeId);
  if (!isTypeRegistered) {
    return registeredAttachmentCommonLabel;
  }
  const props = {
    ...getAttachmentProps(),
    caseData: {
      id: caseData.id,
      title: caseData.title
    }
  };
  const attachmentType = registry.get(attachmentTypeId);
  const attachmentLabel = (_attachmentType$getAt = (_attachmentType$getAt2 = attachmentType.getAttachmentRemovalObject) === null || _attachmentType$getAt2 === void 0 ? void 0 : _attachmentType$getAt2.call(attachmentType, props).event) !== null && _attachmentType$getAt !== void 0 ? _attachmentType$getAt : null;
  return attachmentLabel != null ? attachmentLabel : registeredAttachmentCommonLabel;
};
const getDeleteCommentUserAction = ({
  userAction,
  userProfiles,
  caseData,
  externalReferenceAttachmentTypeRegistry,
  persistableStateAttachmentTypeRegistry,
  handleOutlineComment
}) => {
  const label = getDeleteLabelTitle({
    userAction,
    caseData,
    externalReferenceAttachmentTypeRegistry,
    persistableStateAttachmentTypeRegistry
  });
  const commonBuilder = (0, _common.createCommonUpdateUserActionBuilder)({
    userAction,
    userProfiles,
    handleOutlineComment,
    label,
    icon: 'cross'
  });
  return commonBuilder.build();
};
const getCreateCommentUserAction = ({
  appId,
  userAction,
  userProfiles,
  caseData,
  externalReferenceAttachmentTypeRegistry,
  persistableStateAttachmentTypeRegistry,
  comment,
  commentRefs,
  manageMarkdownEditIds,
  selectedOutlineCommentId,
  loadingCommentIds,
  handleManageMarkdownEditId,
  handleSaveComment,
  handleManageQuote,
  handleDeleteComment,
  getRuleDetailsHref,
  loadingAlertData,
  onRuleDetailsClick,
  alertData,
  onShowAlertDetails,
  actionsNavigation
}) => {
  switch (comment.type) {
    case _domain.AttachmentType.user:
      const userBuilder = (0, _user.createUserAttachmentUserActionBuilder)({
        appId,
        userProfiles,
        comment,
        outlined: comment.id === selectedOutlineCommentId,
        isEdit: manageMarkdownEditIds.includes(comment.id),
        commentRefs,
        isLoading: loadingCommentIds.includes(comment.id),
        caseId: caseData.id,
        handleManageMarkdownEditId,
        handleSaveComment,
        handleManageQuote,
        handleDeleteComment
      });
      return userBuilder.build();
    case _domain.AttachmentType.alert:
      const alertBuilder = (0, _alert.createAlertAttachmentUserActionBuilder)({
        userProfiles,
        alertData,
        comment,
        userAction,
        getRuleDetailsHref,
        loadingAlertData,
        onRuleDetailsClick,
        onShowAlertDetails,
        handleDeleteComment,
        loadingCommentIds
      });
      return alertBuilder.build();
    case _domain.AttachmentType.actions:
      const actionBuilder = (0, _actions.createActionAttachmentUserActionBuilder)({
        userProfiles,
        userAction,
        comment,
        actionsNavigation
      });
      return actionBuilder.build();
    case _domain.AttachmentType.externalReference:
      const externalReferenceBuilder = (0, _external_reference.createExternalReferenceAttachmentUserActionBuilder)({
        userAction,
        userProfiles,
        comment,
        externalReferenceAttachmentTypeRegistry,
        caseData,
        isLoading: loadingCommentIds.includes(comment.id),
        handleDeleteComment
      });
      return externalReferenceBuilder.build();
    case _domain.AttachmentType.persistableState:
      const persistableBuilder = (0, _persistable_state.createPersistableStateAttachmentUserActionBuilder)({
        userAction,
        userProfiles,
        comment,
        persistableStateAttachmentTypeRegistry,
        caseData,
        isLoading: loadingCommentIds.includes(comment.id),
        handleDeleteComment
      });
      return persistableBuilder.build();
    default:
      return [];
  }
};
const createCommentUserActionBuilder = ({
  appId,
  caseData,
  casesConfiguration,
  userProfiles,
  externalReferenceAttachmentTypeRegistry,
  persistableStateAttachmentTypeRegistry,
  userAction,
  commentRefs,
  manageMarkdownEditIds,
  selectedOutlineCommentId,
  loadingCommentIds,
  loadingAlertData,
  alertData,
  getRuleDetailsHref,
  onRuleDetailsClick,
  onShowAlertDetails,
  handleManageMarkdownEditId,
  handleSaveComment,
  handleDeleteComment,
  handleManageQuote,
  handleOutlineComment,
  actionsNavigation,
  caseConnectors
}) => ({
  build: () => {
    const commentUserAction = userAction;
    if (commentUserAction.action === _domain.UserActionActions.delete) {
      return getDeleteCommentUserAction({
        userAction: commentUserAction,
        caseData,
        handleOutlineComment,
        userProfiles,
        externalReferenceAttachmentTypeRegistry,
        persistableStateAttachmentTypeRegistry
      });
    }
    const comment = caseData.comments.find(c => c.id === commentUserAction.commentId);
    if (comment == null) {
      return [];
    }
    if (commentUserAction.action === _domain.UserActionActions.create) {
      const commentAction = getCreateCommentUserAction({
        appId,
        caseData,
        casesConfiguration,
        userProfiles,
        userAction: commentUserAction,
        externalReferenceAttachmentTypeRegistry,
        persistableStateAttachmentTypeRegistry,
        comment,
        commentRefs,
        manageMarkdownEditIds,
        selectedOutlineCommentId,
        loadingCommentIds,
        loadingAlertData,
        alertData,
        getRuleDetailsHref,
        onRuleDetailsClick,
        onShowAlertDetails,
        handleManageMarkdownEditId,
        handleSaveComment,
        handleDeleteComment,
        handleManageQuote,
        actionsNavigation,
        caseConnectors
      });
      return commentAction;
    }
    const label = getUpdateLabelTitle();
    const commonBuilder = (0, _common.createCommonUpdateUserActionBuilder)({
      userAction,
      userProfiles,
      handleOutlineComment,
      label,
      icon: 'dot'
    });
    return commonBuilder.build();
  }
});
exports.createCommentUserActionBuilder = createCommentUserActionBuilder;