"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleAlertCommentEvent = exports.MultipleAlertsCommentEvent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../translations"));
var _links = require("../../links");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleLink = /*#__PURE__*/(0, _react.memo)(({
  onRuleDetailsClick,
  getRuleDetailsHref,
  ruleId,
  ruleName,
  loadingAlertData,
  actionId
}) => {
  const onLinkClick = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    if (onRuleDetailsClick) onRuleDetailsClick(ruleId, ev);
  }, [ruleId, onRuleDetailsClick]);
  const ruleDetailsHref = getRuleDetailsHref === null || getRuleDetailsHref === void 0 ? void 0 : getRuleDetailsHref(ruleId);
  const finalRuleName = ruleName !== null && ruleName !== void 0 ? ruleName : i18n.UNKNOWN_RULE;
  if (loadingAlertData) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      "data-test-subj": `alert-loading-spinner-${actionId}`
    });
  }
  if (!(0, _lodash.isEmpty)(ruleId) && ruleDetailsHref != null) {
    return /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
      onClick: onLinkClick,
      href: ruleDetailsHref,
      "data-test-subj": `alert-rule-link-${actionId}`
    }, finalRuleName);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, finalRuleName);
});
RuleLink.displayName = 'RuleLink';
const SingleAlertCommentEventComponent = ({
  actionId,
  getRuleDetailsHref,
  loadingAlertData = false,
  onRuleDetailsClick,
  ruleId,
  ruleName
}) => {
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": `single-alert-user-action-${actionId}`
  }, `${i18n.ALERT_COMMENT_LABEL_TITLE} `, /*#__PURE__*/_react.default.createElement(RuleLink, {
    actionId: actionId,
    ruleId: ruleId,
    ruleName: ruleName,
    getRuleDetailsHref: getRuleDetailsHref,
    onRuleDetailsClick: onRuleDetailsClick,
    loadingAlertData: loadingAlertData
  }));
};
SingleAlertCommentEventComponent.displayName = 'SingleAlertCommentEvent';
const SingleAlertCommentEvent = /*#__PURE__*/(0, _react.memo)(SingleAlertCommentEventComponent);
exports.SingleAlertCommentEvent = SingleAlertCommentEvent;
const MultipleAlertsCommentEventComponent = ({
  actionId,
  getRuleDetailsHref,
  loadingAlertData = false,
  onRuleDetailsClick,
  ruleId,
  ruleName,
  totalAlerts
}) => {
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": `multiple-alerts-user-action-${actionId}`
  }, `${i18n.MULTIPLE_ALERTS_COMMENT_LABEL_TITLE(totalAlerts)}`, ' ', /*#__PURE__*/_react.default.createElement(RuleLink, {
    actionId: actionId,
    ruleId: ruleId,
    ruleName: ruleName,
    getRuleDetailsHref: getRuleDetailsHref,
    onRuleDetailsClick: onRuleDetailsClick,
    loadingAlertData: loadingAlertData
  }));
};
MultipleAlertsCommentEventComponent.displayName = 'MultipleAlertsCommentEvent';
const MultipleAlertsCommentEvent = /*#__PURE__*/(0, _react.memo)(MultipleAlertsCommentEventComponent);
exports.MultipleAlertsCommentEvent = MultipleAlertsCommentEvent;