"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditableMarkdown = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _ = require(".");
var _utils = require("../utils");
var _use_cases_context = require("../cases_context/use_cases_context");
var _utils2 = require("./utils");
var _editable_markdown_footer = require("./editable_markdown_footer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditableMarkDownRenderer = /*#__PURE__*/(0, _react.forwardRef)(({
  id,
  content,
  caseId,
  fieldName,
  onChangeEditable,
  onSaveContent,
  editorRef,
  formSchema
}, ref) => {
  const {
    appId
  } = (0, _use_cases_context.useCasesContext)();
  const draftStorageKey = (0, _utils2.getMarkdownEditorStorageKey)(appId, caseId, id);
  const initialState = {
    content
  };
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: initialState,
    options: {
      stripEmptyFields: false
    },
    schema: formSchema
  });
  const {
    submit,
    setFieldValue,
    isValid: isFormValid
  } = form;
  const setComment = (0, _react.useCallback)(newComment => {
    setFieldValue(fieldName, newComment);
  }, [setFieldValue, fieldName]);
  (0, _react.useImperativeHandle)(ref, () => ({
    setComment,
    editor: editorRef.current
  }));
  const handleCancelAction = (0, _react.useCallback)(() => {
    onChangeEditable(id);
    (0, _utils.removeItemFromSessionStorage)(draftStorageKey);
  }, [id, onChangeEditable, draftStorageKey]);
  const handleSaveAction = (0, _react.useCallback)(async () => {
    const {
      isValid,
      data
    } = await submit();
    if (isValid && data.content !== content) {
      onSaveContent(data.content);
    }
    onChangeEditable(id);
    (0, _utils.removeItemFromSessionStorage)(draftStorageKey);
  }, [content, id, onChangeEditable, onSaveContent, submit, draftStorageKey]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form,
    "data-test-subj": "editable-markdown-form"
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: fieldName,
    component: _.MarkdownEditorForm,
    componentProps: {
      ref: editorRef,
      'aria-label': 'Cases markdown editor',
      value: content,
      id,
      draftStorageKey,
      bottomRightContent: /*#__PURE__*/_react.default.createElement(_editable_markdown_footer.EditableMarkdownFooter, {
        handleSaveAction: handleSaveAction,
        handleCancelAction: handleCancelAction,
        isSaveDisabled: isFormValid !== undefined && !isFormValid
      }),
      initialValue: content
    }
  }));
});
EditableMarkDownRenderer.displayName = 'EditableMarkDownRenderer';
const EditableMarkdown = /*#__PURE__*/_react.default.memo(EditableMarkDownRenderer);
exports.EditableMarkdown = EditableMarkdown;