"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomFieldsList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../translations"));
var _builder = require("../builder");
var _delete_confirmation_modal = require("../delete_confirmation_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomFieldsListComponent = props => {
  const {
    customFields,
    onDeleteCustomField,
    onEditCustomField
  } = props;
  const [selectedItem, setSelectedItem] = (0, _react.useState)(null);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const renderTypeLabel = type => {
    const createdBuilder = type && _builder.builderMap[type];
    return createdBuilder && createdBuilder().label;
  };
  const onConfirm = (0, _react.useCallback)(() => {
    if (selectedItem) {
      onDeleteCustomField(selectedItem.key);
    }
    setSelectedItem(null);
  }, [onDeleteCustomField, setSelectedItem, selectedItem]);
  const onCancel = (0, _react.useCallback)(() => {
    setSelectedItem(null);
  }, []);
  const showModal = Boolean(selectedItem);
  return customFields.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    "data-test-subj": "custom-fields-list"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, customFields.map(customField => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: customField.key
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    "data-test-subj": `custom-field-${customField.key}-${customField.type}`,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, customField.label))), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: euiTheme.colors.body
  }, renderTypeLabel(customField.type)), customField.required && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: euiTheme.colors.body
  }, i18n.REQUIRED))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": `${customField.key}-custom-field-edit`,
    "aria-label": `${customField.key}-custom-field-edit`,
    iconType: "pencil",
    color: "primary",
    onClick: () => onEditCustomField(customField.key)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": `${customField.key}-custom-field-delete`,
    "aria-label": `${customField.key}-custom-field-delete`,
    iconType: "minusInCircle",
    color: "danger",
    onClick: () => setSelectedItem(customField)
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))), showModal && selectedItem ? /*#__PURE__*/_react.default.createElement(_delete_confirmation_modal.DeleteConfirmationModal, {
    label: selectedItem.label,
    onCancel: onCancel,
    onConfirm: onConfirm
  }) : null)) : null;
};
CustomFieldsListComponent.displayName = 'CustomFieldsList';
const CustomFieldsList = /*#__PURE__*/_react.default.memo(CustomFieldsListComponent);
exports.CustomFieldsList = CustomFieldsList;