"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _domain = require("../../../../common/types/domain");
var _card = require("../card");
var _validator = require("./validator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SwimlaneFieldsPreviewComponent = ({
  connector
}) => {
  const showMappingWarning = (0, _react.useMemo)(() => (0, _validator.connectorValidator)(connector) != null, [connector]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_card.ConnectorCard, {
    connectorType: _domain.ConnectorTypes.swimlane,
    isLoading: false,
    listItems: [],
    title: connector.name
  }), showMappingWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.EMPTY_MAPPING_WARNING_TITLE,
    color: "danger",
    iconType: "warning",
    "data-test-subj": "mapping-warning-callout"
  }, i18n.EMPTY_MAPPING_WARNING_DESC));
};
exports.default = SwimlaneFieldsPreviewComponent;
SwimlaneFieldsPreviewComponent.displayName = 'SwimlaneFieldsPreview';

// eslint-disable-next-line import/no-default-export
module.exports = exports.default;