"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldMappingRowStatic = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldMappingRowComponent = ({
  isLoading,
  casesField,
  selectedActionType,
  selectedThirdParty
}) => {
  const selectedActionTypeCapitalized = (0, _react.useMemo)(() => (0, _fp.capitalize)(selectedActionType), [selectedActionType]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "static-mappings",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    component: "span",
    justifyContent: "spaceBetween",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    "data-test-subj": "field-mapping-source"
  }, casesField)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortRight"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    component: "span",
    justifyContent: "spaceBetween",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    component: "span",
    grow: false
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    "data-test-subj": "field-mapping-target"
  }, selectedThirdParty)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  }) : selectedActionTypeCapitalized));
};
FieldMappingRowComponent.displayName = 'FieldMappingRow';
const FieldMappingRowStatic = /*#__PURE__*/_react.default.memo(FieldMappingRowComponent);
exports.FieldMappingRowStatic = FieldMappingRowStatic;