"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connectors = exports.actionTypes = void 0;
Object.defineProperty(exports, "mappings", {
  enumerable: true,
  get: function () {
    return _mock.mappings;
  }
});
exports.usePersistConfigurationMockResponse = exports.useConnectorsResponse = exports.useCaseConfigureResponse = exports.useActionTypesResponse = exports.searchURL = void 0;
var _domain = require("../../../../common/types/domain");
var _connectors = require("../../../common/mock/connectors");
var _mock = require("../../../containers/configure/mock");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const connectors = _connectors.connectorsMock;
exports.connectors = connectors;
const actionTypes = _connectors.actionTypesMock;
exports.actionTypes = actionTypes;
const searchURL = '?timerange=(global:(linkTo:!(),timerange:(from:1585487656371,fromStr:now-24h,kind:relative,to:1585574056371,toStr:now)),timeline:(linkTo:!(),timerange:(from:1585227005527,kind:absolute,to:1585313405527)))';
exports.searchURL = searchURL;
const useCaseConfigureResponse = {
  data: {
    closureType: 'close-by-user',
    connector: {
      fields: null,
      id: 'none',
      name: 'none',
      type: _domain.ConnectorTypes.none
    },
    customFields: [],
    mappings: [],
    version: '',
    id: ''
  },
  isLoading: false,
  isFetching: false,
  refetch: jest.fn()
};
exports.useCaseConfigureResponse = useCaseConfigureResponse;
const usePersistConfigurationMockResponse = {
  isLoading: false,
  mutate: jest.fn(),
  mutateAsync: jest.fn()
};
exports.usePersistConfigurationMockResponse = usePersistConfigurationMockResponse;
const useConnectorsResponse = {
  isLoading: false,
  data: connectors,
  refetch: jest.fn()
};
exports.useConnectorsResponse = useConnectorsResponse;
const useActionTypesResponse = {
  isLoading: false,
  data: _connectors.actionTypesMock,
  refetch: jest.fn()
};
exports.useActionTypesResponse = useActionTypesResponse;