"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useApplication = void 0;
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _kibana = require("../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useApplication = () => {
  var _applications$get$cat, _applications$get, _applications$get$cat2, _applications$get2;
  const {
    currentAppId$,
    applications$
  } = (0, _kibana.useKibana)().services.application;
  // retrieve the most recent value from the BehaviorSubject
  const appId = (0, _useObservable.default)(currentAppId$);
  const applications = (0, _useObservable.default)(applications$);
  const appTitle = appId ? (_applications$get$cat = applications === null || applications === void 0 ? void 0 : (_applications$get = applications.get(appId)) === null || _applications$get === void 0 ? void 0 : (_applications$get$cat2 = _applications$get.category) === null || _applications$get$cat2 === void 0 ? void 0 : _applications$get$cat2.label) !== null && _applications$get$cat !== void 0 ? _applications$get$cat : applications === null || applications === void 0 ? void 0 : (_applications$get2 = applications.get(appId)) === null || _applications$get2 === void 0 ? void 0 : _applications$get2.title : undefined;
  return {
    appId,
    appTitle
  };
};
exports.useApplication = useApplication;