"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseViewMetrics = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_get_case_metrics = require("../../../containers/use_get_case_metrics");
var _totals = require("./totals");
var _status = require("./status");
var _use_cases_features = require("../../../common/use_cases_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CaseViewMetrics = /*#__PURE__*/_react.default.memo(({
  caseId
}) => {
  const {
    metricsFeatures
  } = (0, _use_cases_features.useCasesFeatures)();
  const {
    data,
    isLoading
  } = (0, _use_get_case_metrics.useGetCaseMetrics)(caseId, metricsFeatures);
  if (metricsFeatures.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "case-view-metrics-panel",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    wrap: true,
    responsive: false,
    alignItems: "center"
  }, isLoading || !data ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "case-view-metrics-spinner",
    size: "l"
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_totals.CaseViewMetricItems, {
    metrics: data.metrics,
    features: metricsFeatures
  }), /*#__PURE__*/_react.default.createElement(_status.CaseStatusMetrics, {
    metrics: data.metrics,
    features: metricsFeatures
  }))));
});
exports.CaseViewMetrics = CaseViewMetrics;
CaseViewMetrics.displayName = 'CaseViewMetrics';