"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_CASE_FILES_FILTERING_OPTIONS = exports.CaseViewFiles = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _types = require("../../../../common/types");
var _use_get_case_files = require("../../../containers/use_get_case_files");
var _files_table = require("../../files/files_table");
var _case_view_tabs = require("../case_view_tabs");
var _files_utility_bar = require("../../files/files_utility_bar");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_CASE_FILES_FILTERING_OPTIONS = {
  page: 0,
  perPage: 10
};
exports.DEFAULT_CASE_FILES_FILTERING_OPTIONS = DEFAULT_CASE_FILES_FILTERING_OPTIONS;
const CaseViewFiles = ({
  caseData
}) => {
  var _caseFiles$files;
  const [filteringOptions, setFilteringOptions] = (0, _react.useState)(DEFAULT_CASE_FILES_FILTERING_OPTIONS);
  const {
    data: caseFiles,
    isLoading,
    isPreviousData
  } = (0, _use_get_case_files.useGetCaseFiles)({
    ...filteringOptions,
    caseId: caseData.id
  });
  const onTableChange = (0, _react.useCallback)(({
    page
  }) => {
    if (page && !isPreviousData) {
      setFilteringOptions({
        ...filteringOptions,
        page: page.index,
        perPage: page.size
      });
    }
  }, [filteringOptions, isPreviousData]);
  const onSearchChange = (0, _react.useCallback)(newSearch => {
    const trimSearch = newSearch.trim();
    if (!(0, _fp.isEqual)(trimSearch, filteringOptions.searchTerm)) {
      setFilteringOptions({
        ...filteringOptions,
        searchTerm: trimSearch
      });
    }
  }, [filteringOptions]);
  const pagination = (0, _react.useMemo)(() => {
    var _caseFiles$total;
    return {
      pageIndex: filteringOptions.page,
      pageSize: filteringOptions.perPage,
      totalItemCount: (_caseFiles$total = caseFiles === null || caseFiles === void 0 ? void 0 : caseFiles.total) !== null && _caseFiles$total !== void 0 ? _caseFiles$total : 0,
      pageSizeOptions: [10, 25, 50],
      showPerPageOptions: true
    };
  }, [filteringOptions.page, filteringOptions.perPage, caseFiles === null || caseFiles === void 0 ? void 0 : caseFiles.total]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_case_view_tabs.CaseViewTabs, {
    caseData: caseData,
    activeTab: _types.CASE_VIEW_PAGE_TABS.FILES
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_files_utility_bar.FilesUtilityBar, {
    caseId: caseData.id,
    onSearch: onSearchChange
  }), /*#__PURE__*/_react.default.createElement(_files_table.FilesTable, {
    caseId: caseData.id,
    isLoading: isLoading,
    items: (_caseFiles$files = caseFiles === null || caseFiles === void 0 ? void 0 : caseFiles.files) !== null && _caseFiles$files !== void 0 ? _caseFiles$files : [],
    onChange: onTableChange,
    pagination: pagination
  })))));
};
exports.CaseViewFiles = CaseViewFiles;
CaseViewFiles.displayName = 'CaseViewFiles';