"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Actions = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../case_view/translations"));
var _use_delete_cases = require("../../containers/use_delete_cases");
var _confirm_delete_case = require("../confirm_delete_case");
var _property_actions = require("../property_actions");
var _navigation = require("../../common/navigation");
var _use_cases_context = require("../cases_context/use_cases_context");
var _use_cases_toast = require("../../common/use_cases_toast");
var _types = require("../../client/attachment_framework/types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionsComponent = ({
  caseData,
  currentExternalIncident
}) => {
  const {
    mutate: deleteCases
  } = (0, _use_delete_cases.useDeleteCases)();
  const {
    navigateToAllCases
  } = (0, _navigation.useAllCasesNavigation)();
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const {
    showSuccessToast
  } = (0, _use_cases_toast.useCasesToast)();
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const openModal = (0, _react.useCallback)(() => {
    setIsModalVisible(true);
  }, []);
  const closeModal = (0, _react.useCallback)(() => {
    setIsModalVisible(false);
  }, []);
  const propertyActions = (0, _react.useMemo)(() => {
    var _currentExternalIncid;
    return [{
      type: _types.AttachmentActionType.BUTTON,
      iconType: 'copyClipboard',
      label: i18n.COPY_ID_ACTION_LABEL,
      onClick: () => {
        navigator.clipboard.writeText(caseData.id);
        showSuccessToast(i18n.COPY_ID_ACTION_SUCCESS);
      }
    }, ...(currentExternalIncident != null && !(0, _fp.isEmpty)(currentExternalIncident === null || currentExternalIncident === void 0 ? void 0 : currentExternalIncident.externalUrl) ? [{
      type: _types.AttachmentActionType.BUTTON,
      iconType: 'popout',
      label: i18n.VIEW_INCIDENT((_currentExternalIncid = currentExternalIncident === null || currentExternalIncident === void 0 ? void 0 : currentExternalIncident.externalTitle) !== null && _currentExternalIncid !== void 0 ? _currentExternalIncid : ''),
      onClick: () => window.open(currentExternalIncident === null || currentExternalIncident === void 0 ? void 0 : currentExternalIncident.externalUrl, '_blank')
    }] : []), ...(permissions.delete ? [{
      type: _types.AttachmentActionType.BUTTON,
      iconType: 'trash',
      label: i18n.DELETE_CASE(),
      color: 'danger',
      onClick: openModal
    }] : [])];
  }, [permissions.delete, openModal, currentExternalIncident, caseData.id, showSuccessToast]);
  const onConfirmDeletion = (0, _react.useCallback)(() => {
    setIsModalVisible(false);
    deleteCases({
      caseIds: [caseData.id],
      successToasterTitle: i18n.DELETED_CASES(1)
    }, {
      onSuccess: navigateToAllCases
    });
  }, [caseData.id, deleteCases, navigateToAllCases]);
  if (propertyActions.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "case-view-actions"
  }, /*#__PURE__*/_react.default.createElement(_property_actions.PropertyActions, {
    propertyActions: propertyActions,
    customDataTestSubj: 'case'
  }), isModalVisible ? /*#__PURE__*/_react.default.createElement(_confirm_delete_case.ConfirmDeleteCaseModal, {
    totalCasesToBeDeleted: 1,
    onCancel: closeModal,
    onConfirm: onConfirmDeletion
  }) : null);
};
ActionsComponent.displayName = 'Actions';
const Actions = /*#__PURE__*/_react.default.memo(ActionsComponent);
exports.Actions = Actions;