"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getQueryParamsLocalStorageKey = exports.getFilterOptionsLocalStorageKey = void 0;
exports.useAllCasesState = useAllCasesState;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _lodash = require("lodash");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _sanitize_filter_options = require("./utils/sanitize_filter_options");
var _constants = require("../../containers/constants");
var _utils = require("./utils");
var _utils2 = require("../utils");
var _constants2 = require("../../../common/constants");
var _types = require("../../../common/ui/types");
var _use_cases_context = require("../cases_context/use_cases_context");
var _types2 = require("./types");
var _parse_url_with_filter_options = require("./utils/parse_url_with_filter_options");
var _serialize_url_params = require("./utils/serialize_url_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getQueryParamsLocalStorageKey = appId => {
  const filteringKey = _constants2.LOCAL_STORAGE_KEYS.casesQueryParams;
  return `${appId}.${filteringKey}`;
};
exports.getQueryParamsLocalStorageKey = getQueryParamsLocalStorageKey;
const getFilterOptionsLocalStorageKey = appId => {
  const filteringKey = _constants2.LOCAL_STORAGE_KEYS.casesFilterOptions;
  return `${appId}.${filteringKey}`;
};
exports.getFilterOptionsLocalStorageKey = getFilterOptionsLocalStorageKey;
const getQueryParams = (params, urlParams, localStorageQueryParams) => {
  var _ref, _ref2, _params$perPage, _ref3, _ref4, _params$sortField, _ref5, _ref6, _params$sortOrder, _ref7, _params$page;
  const result = {
    ..._constants.DEFAULT_QUERY_PARAMS
  };
  result.perPage = (_ref = (_ref2 = (_params$perPage = params.perPage) !== null && _params$perPage !== void 0 ? _params$perPage : urlParams.perPage) !== null && _ref2 !== void 0 ? _ref2 : localStorageQueryParams === null || localStorageQueryParams === void 0 ? void 0 : localStorageQueryParams.perPage) !== null && _ref !== void 0 ? _ref : _constants.DEFAULT_QUERY_PARAMS.perPage;
  result.sortField = (_ref3 = (_ref4 = (_params$sortField = params.sortField) !== null && _params$sortField !== void 0 ? _params$sortField : urlParams.sortField) !== null && _ref4 !== void 0 ? _ref4 : localStorageQueryParams === null || localStorageQueryParams === void 0 ? void 0 : localStorageQueryParams.sortField) !== null && _ref3 !== void 0 ? _ref3 : _constants.DEFAULT_QUERY_PARAMS.sortField;
  result.sortOrder = (_ref5 = (_ref6 = (_params$sortOrder = params.sortOrder) !== null && _params$sortOrder !== void 0 ? _params$sortOrder : urlParams.sortOrder) !== null && _ref6 !== void 0 ? _ref6 : localStorageQueryParams === null || localStorageQueryParams === void 0 ? void 0 : localStorageQueryParams.sortOrder) !== null && _ref5 !== void 0 ? _ref5 : _constants.DEFAULT_QUERY_PARAMS.sortOrder;
  result.page = (_ref7 = (_params$page = params.page) !== null && _params$page !== void 0 ? _params$page : urlParams.page) !== null && _ref7 !== void 0 ? _ref7 : _constants.DEFAULT_QUERY_PARAMS.page;
  return result;
};
const validateQueryParams = queryParams => {
  const perPage = Math.min(queryParams.perPage, _types2.CASES_TABLE_PERPAGE_VALUES[_types2.CASES_TABLE_PERPAGE_VALUES.length - 1]);
  const sortOrder = !_types.SORT_ORDER_VALUES.includes(queryParams.sortOrder) ? _constants.DEFAULT_QUERY_PARAMS.sortOrder : queryParams.sortOrder;
  return {
    ...queryParams,
    perPage,
    sortOrder
  };
};

/**
 * Previously, 'status' and 'severity' were represented as single options (strings).
 * To maintain backward compatibility while transitioning to the new type of string[],
 * we map the legacy type to the new type.
 */
const convertToFilterOptionArray = value => {
  if (typeof value === 'string') {
    return [value];
  }
  return value;
};
const getFilterOptions = (filterOptions, params, urlParams, localStorageFilterOptions) => {
  var _ref8, _ref9, _params$severity, _ref10, _ref11, _params$status;
  const severity = (_ref8 = (_ref9 = (_params$severity = params === null || params === void 0 ? void 0 : params.severity) !== null && _params$severity !== void 0 ? _params$severity : urlParams === null || urlParams === void 0 ? void 0 : urlParams.severity) !== null && _ref9 !== void 0 ? _ref9 : convertToFilterOptionArray(localStorageFilterOptions === null || localStorageFilterOptions === void 0 ? void 0 : localStorageFilterOptions.severity)) !== null && _ref8 !== void 0 ? _ref8 : _constants.DEFAULT_FILTER_OPTIONS.severity;
  const status = (_ref10 = (_ref11 = (_params$status = params === null || params === void 0 ? void 0 : params.status) !== null && _params$status !== void 0 ? _params$status : urlParams === null || urlParams === void 0 ? void 0 : urlParams.status) !== null && _ref11 !== void 0 ? _ref11 : convertToFilterOptionArray(localStorageFilterOptions === null || localStorageFilterOptions === void 0 ? void 0 : localStorageFilterOptions.status)) !== null && _ref10 !== void 0 ? _ref10 : _constants.DEFAULT_FILTER_OPTIONS.status;
  return {
    ...filterOptions,
    ...params,
    ...(0, _sanitize_filter_options.removeLegacyValuesFromOptions)({
      status,
      severity
    })
  };
};
function useAllCasesState(isModalView = false, initialFilterOptions) {
  const {
    appId
  } = (0, _use_cases_context.useCasesContext)();
  const location = (0, _reactRouterDom.useLocation)();
  const history = (0, _reactRouterDom.useHistory)();
  const isFirstRenderRef = (0, _react.useRef)(true);
  const [queryParams, setQueryParams] = (0, _react.useState)({
    ..._constants.DEFAULT_QUERY_PARAMS
  });
  const [filterOptions, setFilterOptions] = (0, _react.useState)({
    ..._constants.DEFAULT_FILTER_OPTIONS,
    ...initialFilterOptions
  });
  const [localStorageQueryParams, setLocalStorageQueryParams] = (0, _useLocalStorage.default)(getQueryParamsLocalStorageKey(appId));
  const [localStorageFilterOptions, setLocalStorageFilterOptions] = (0, _useLocalStorage.default)(getFilterOptionsLocalStorageKey(appId));
  const persistAndUpdateQueryParams = (0, _react.useCallback)(params => {
    if (isModalView) {
      setQueryParams(prevParams => ({
        ...prevParams,
        ...params
      }));
      return;
    }
    const parsedUrlParams = (0, _utils2.parseURL)(location.search);
    const urlParams = (0, _utils.parseUrlQueryParams)(parsedUrlParams);
    let newQueryParams = getQueryParams(params, urlParams, localStorageQueryParams);
    newQueryParams = validateQueryParams(newQueryParams);
    const newLocalStorageQueryParams = {
      perPage: newQueryParams.perPage,
      sortField: newQueryParams.sortField,
      sortOrder: newQueryParams.sortOrder
    };
    setLocalStorageQueryParams(newLocalStorageQueryParams);
    setQueryParams(newQueryParams);
  }, [isModalView, location.search, localStorageQueryParams, setLocalStorageQueryParams]);
  const persistAndUpdateFilterOptions = (0, _react.useCallback)(params => {
    if (isModalView) {
      setFilterOptions(prevParams => ({
        ...prevParams,
        ...params
      }));
      return;
    }
    const newFilterOptions = getFilterOptions(filterOptions, params, (0, _parse_url_with_filter_options.parseURLWithFilterOptions)(location.search), localStorageFilterOptions);
    const newPersistedFilterOptions = (0, _sanitize_filter_options.getStorableFilters)(newFilterOptions);
    const newLocalStorageFilterOptions = {
      ...localStorageFilterOptions,
      ...newPersistedFilterOptions
    };
    setLocalStorageFilterOptions(newLocalStorageFilterOptions);
    setFilterOptions(newFilterOptions);
  }, [filterOptions, isModalView, localStorageFilterOptions, location.search, setLocalStorageFilterOptions]);
  const updateLocation = (0, _react.useCallback)(() => {
    const parsedUrlParams = (0, _parse_url_with_filter_options.parseURLWithFilterOptions)(location.search);
    const stateUrlParams = {
      ...parsedUrlParams,
      ...queryParams,
      ...(0, _sanitize_filter_options.getStorableFilters)(filterOptions),
      page: queryParams.page.toString(),
      perPage: queryParams.perPage.toString()
    };
    if (!(0, _lodash.isEqual)(parsedUrlParams, stateUrlParams)) {
      try {
        const urlParams = (0, _serialize_url_params.serializeUrlParams)({
          ...parsedUrlParams,
          ...stateUrlParams
        });
        const newHistory = {
          ...location,
          search: (0, _utils2.stringifyToURL)(urlParams)
        };
        history.replace(newHistory);
      } catch {
        // silently fail
      }
    }
  }, [filterOptions, history, location, queryParams]);
  if (isFirstRenderRef.current) {
    persistAndUpdateQueryParams(isModalView ? queryParams : {});
    persistAndUpdateFilterOptions(isModalView ? filterOptions : initialFilterOptions);
    isFirstRenderRef.current = false;
  }
  (0, _react.useEffect)(() => {
    if (!isModalView) {
      updateLocation();
    }
  }, [isModalView, updateLocation]);
  return {
    queryParams,
    setQueryParams: persistAndUpdateQueryParams,
    filterOptions,
    setFilterOptions: persistAndUpdateFilterOptions
  };
}