"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTagsAction = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_items_action = require("../use_items_action");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTagsAction = ({
  onAction,
  onActionSuccess,
  isDisabled
}) => {
  const {
    isFlyoutOpen,
    onFlyoutClosed,
    onSaveItems,
    openFlyout,
    isActionDisabled
  } = (0, _use_items_action.useItemsAction)({
    fieldKey: 'tags',
    isDisabled,
    onAction,
    onActionSuccess,
    successToasterTitle: i18n.EDITED_CASES,
    fieldSelector: theCase => theCase.tags,
    itemsTransformer: items => items
  });
  const getAction = selectedCases => {
    return {
      name: i18n.EDIT_TAGS,
      onClick: () => openFlyout(selectedCases),
      disabled: isActionDisabled,
      'data-test-subj': 'cases-bulk-action-tags',
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "tag",
        size: "m"
      }),
      key: 'cases-bulk-action-tags'
    };
  };
  return {
    getAction,
    isFlyoutOpen,
    onFlyoutClosed,
    onSaveTags: onSaveItems
  };
};
exports.useTagsAction = useTagsAction;