"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStatusAction = void 0;
var _react = require("react");
var _use_bulk_update_case = require("../../../containers/use_bulk_update_case");
var _domain = require("../../../../common/types/domain");
var i18n = _interopRequireWildcard(require("./translations"));
var _status = require("../../status");
var _use_cases_context = require("../../cases_context/use_cases_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getStatusToasterMessage = (status, cases) => {
  const totalCases = cases.length;
  const caseTitle = totalCases === 1 ? cases[0].title : '';
  if (status === _domain.CaseStatuses.open) {
    return i18n.REOPENED_CASES({
      totalCases,
      caseTitle
    });
  } else if (status === _domain.CaseStatuses['in-progress']) {
    return i18n.MARK_IN_PROGRESS_CASES({
      totalCases,
      caseTitle
    });
  } else if (status === _domain.CaseStatuses.closed) {
    return i18n.CLOSED_CASES({
      totalCases,
      caseTitle
    });
  }
  return '';
};
const shouldDisableStatus = (cases, status) => cases.every(theCase => theCase.status === status);
const useStatusAction = ({
  onAction,
  onActionSuccess,
  isDisabled,
  selectedStatus
}) => {
  const {
    mutate: updateCases
  } = (0, _use_bulk_update_case.useUpdateCases)();
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const canUpdateStatus = permissions.update;
  const isActionDisabled = isDisabled || !canUpdateStatus;
  const handleUpdateCaseStatus = (0, _react.useCallback)((selectedCases, status) => {
    onAction();
    const casesToUpdate = selectedCases.map(theCase => ({
      status,
      id: theCase.id,
      version: theCase.version
    }));
    updateCases({
      cases: casesToUpdate,
      successToasterTitle: getStatusToasterMessage(status, selectedCases)
    }, {
      onSuccess: onActionSuccess
    });
  }, [onAction, updateCases, onActionSuccess]);
  const getStatusIcon = status => selectedStatus && selectedStatus === status ? 'check' : 'empty';
  const getActions = selectedCases => {
    return [{
      name: _status.statuses[_domain.CaseStatuses.open].label,
      icon: getStatusIcon(_domain.CaseStatuses.open),
      onClick: () => handleUpdateCaseStatus(selectedCases, _domain.CaseStatuses.open),
      disabled: isActionDisabled || shouldDisableStatus(selectedCases, _domain.CaseStatuses.open),
      'data-test-subj': 'cases-bulk-action-status-open',
      key: 'cases-bulk-action-status-open'
    }, {
      name: _status.statuses[_domain.CaseStatuses['in-progress']].label,
      icon: getStatusIcon(_domain.CaseStatuses['in-progress']),
      onClick: () => handleUpdateCaseStatus(selectedCases, _domain.CaseStatuses['in-progress']),
      disabled: isActionDisabled || shouldDisableStatus(selectedCases, _domain.CaseStatuses['in-progress']),
      'data-test-subj': 'cases-bulk-action-status-in-progress',
      key: 'cases-bulk-action-status-in-progress'
    }, {
      name: _status.statuses[_domain.CaseStatuses.closed].label,
      icon: getStatusIcon(_domain.CaseStatuses.closed),
      onClick: () => handleUpdateCaseStatus(selectedCases, _domain.CaseStatuses.closed),
      disabled: isActionDisabled || shouldDisableStatus(selectedCases, _domain.CaseStatuses.closed),
      'data-test-subj': 'cases-bulk-action-status-closed',
      key: 'cases-bulk-status-action'
    }];
  };
  return {
    getActions,
    canUpdateStatus
  };
};
exports.useStatusAction = useStatusAction;