"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.canUseCases = void 0;
var _constants = require("../../../common/constants");
var _capabilities = require("./capabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Returns an object denoting the current user's ability to read and crud cases.
 * If any owner(securitySolution, Observability) is found with crud or read capability respectively,
 * then crud or read is set to true.
 * Permissions for a specific owners can be found by passing an owner array
 */
const canUseCases = capabilities => (owners = [_constants.OBSERVABILITY_OWNER, _constants.SECURITY_SOLUTION_OWNER, _constants.GENERAL_CASES_OWNER]) => {
  const aggregatedPermissions = owners.reduce((acc, owner) => {
    const userCapabilitiesForOwner = (0, _capabilities.getUICapabilities)(capabilities[getFeatureID(owner)]);
    acc.create = acc.create || userCapabilitiesForOwner.create;
    acc.read = acc.read || userCapabilitiesForOwner.read;
    acc.update = acc.update || userCapabilitiesForOwner.update;
    acc.delete = acc.delete || userCapabilitiesForOwner.delete;
    acc.push = acc.push || userCapabilitiesForOwner.push;
    acc.connectors = acc.connectors || userCapabilitiesForOwner.connectors;
    acc.settings = acc.settings || userCapabilitiesForOwner.settings;
    const allFromAcc = acc.create && acc.read && acc.update && acc.delete && acc.push && acc.connectors && acc.settings;
    acc.all = acc.all || userCapabilitiesForOwner.all || allFromAcc;
    return acc;
  }, {
    all: false,
    create: false,
    read: false,
    update: false,
    delete: false,
    push: false,
    connectors: false,
    settings: false
  });
  return {
    ...aggregatedPermissions
  };
};
exports.canUseCases = canUseCases;
const getFeatureID = owner => {
  if (owner === _constants.GENERAL_CASES_OWNER) {
    return _constants.FEATURE_ID;
  }
  return `${owner}Cases`;
};