"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateMaxUserActions = exports.areTotalAssigneesInvalid = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const areTotalAssigneesInvalid = assignees => {
  if (assignees == null) {
    return false;
  }
  return assignees.length > _constants.MAX_ASSIGNEES_PER_CASE;
};
exports.areTotalAssigneesInvalid = areTotalAssigneesInvalid;
const validateMaxUserActions = async ({
  caseId,
  userActionService,
  userActionsToAdd
}) => {
  var _result$caseId;
  const result = await userActionService.getMultipleCasesUserActionsTotal({
    caseIds: [caseId]
  });
  const totalUserActions = (_result$caseId = result[caseId]) !== null && _result$caseId !== void 0 ? _result$caseId : 0;
  if (totalUserActions + userActionsToAdd > _constants.MAX_USER_ACTIONS_PER_CASE) {
    throw _boom.default.badRequest(`The case with id ${caseId} has reached the limit of ${_constants.MAX_USER_ACTIONS_PER_CASE} user actions.`);
  }
};
exports.validateMaxUserActions = validateMaxUserActions;