"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetCaseConnectorsResponseRt = exports.FindActionConnectorResponseRt = exports.ConnectorMappingResponseRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _v = require("../../domain/external_service/v1");
var _v2 = require("../../domain/connector/v1");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PushDetailsRt = rt.strict({
  latestUserActionPushDate: rt.string,
  oldestUserActionPushDate: rt.string,
  externalService: _v.ExternalServiceRt
});
const CaseConnectorPushInfoRt = rt.intersection([rt.strict({
  needsToBePushed: rt.boolean,
  hasBeenPushed: rt.boolean
}), rt.exact(rt.partial({
  details: PushDetailsRt
}))]);
const GetCaseConnectorsResponseRt = rt.record(rt.string, rt.intersection([rt.strict({
  push: CaseConnectorPushInfoRt
}), _v2.CaseConnectorRt]));
exports.GetCaseConnectorsResponseRt = GetCaseConnectorsResponseRt;
const ActionConnectorResultRt = rt.intersection([rt.strict({
  id: rt.string,
  actionTypeId: rt.string,
  name: rt.string,
  isDeprecated: rt.boolean,
  isPreconfigured: rt.boolean,
  isSystemAction: rt.boolean,
  referencedByCount: rt.number
}), rt.exact(rt.partial({
  config: rt.record(rt.string, rt.unknown),
  isMissingSecrets: rt.boolean
}))]);
const FindActionConnectorResponseRt = rt.array(ActionConnectorResultRt);
exports.FindActionConnectorResponseRt = FindActionConnectorResponseRt;
const ConnectorMappingResponseRt = rt.strict({
  id: rt.string,
  version: rt.string,
  mappings: _v2.ConnectorMappingsRt
});
exports.ConnectorMappingResponseRt = ConnectorMappingResponseRt;