"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindAttachmentsQueryParamsRt = exports.BulkGetAttachmentsResponseRt = exports.BulkGetAttachmentsRequestRt = exports.BulkDeleteFileAttachmentsRequestRt = exports.BulkCreateAttachmentsRequestRt = exports.AttachmentsFindResponseRt = exports.AttachmentRequestWithoutRefsRt = exports.AttachmentRequestRt = exports.AttachmentPatchRequestRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _constants = require("../../../constants");
var _schema = require("../../../schema");
var _v = require("../../domain/attachment/v1");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Files
 */

const MIN_DELETE_IDS = 1;
const BulkDeleteFileAttachmentsRequestRt = rt.strict({
  ids: (0, _schema.limitedArraySchema)({
    codec: _schema.NonEmptyString,
    min: MIN_DELETE_IDS,
    max: _constants.MAX_DELETE_FILES,
    fieldName: 'ids'
  })
});
exports.BulkDeleteFileAttachmentsRequestRt = BulkDeleteFileAttachmentsRequestRt;
const BasicAttachmentRequestRt = rt.union([_v.UserCommentAttachmentPayloadRt, _v.AlertAttachmentPayloadRt, _v.ActionsAttachmentPayloadRt, _v.ExternalReferenceNoSOAttachmentPayloadRt, _v.PersistableStateAttachmentPayloadRt]);
const AttachmentRequestRt = rt.union([rt.strict({
  comment: (0, _schema.limitedStringSchema)({
    fieldName: 'comment',
    min: 1,
    max: _constants.MAX_COMMENT_LENGTH
  }),
  type: rt.literal(_v.AttachmentType.user),
  owner: rt.string
}), _v.AlertAttachmentPayloadRt, rt.strict({
  type: rt.literal(_v.AttachmentType.actions),
  comment: (0, _schema.limitedStringSchema)({
    fieldName: 'comment',
    min: 1,
    max: _constants.MAX_COMMENT_LENGTH
  }),
  actions: rt.strict({
    targets: rt.array(rt.strict({
      hostname: rt.string,
      endpointId: rt.string
    })),
    type: rt.string
  }),
  owner: rt.string
}), _v.ExternalReferenceNoSOAttachmentPayloadRt, _v.ExternalReferenceSOAttachmentPayloadRt, _v.PersistableStateAttachmentPayloadRt]);
exports.AttachmentRequestRt = AttachmentRequestRt;
const AttachmentRequestWithoutRefsRt = rt.union([BasicAttachmentRequestRt, _v.ExternalReferenceSOWithoutRefsAttachmentPayloadRt]);
exports.AttachmentRequestWithoutRefsRt = AttachmentRequestWithoutRefsRt;
const AttachmentPatchRequestRt = rt.intersection([
/**
 * Partial updates are not allowed.
 * We want to prevent the user for changing the type without removing invalid fields.
 *
 * injectAttachmentSOAttributesFromRefsForPatch is dependent on this assumption.
 * The consumers of the persistable attachment service should always get the
 * persistableStateAttachmentState on a patch.
 */
AttachmentRequestRt, rt.strict({
  id: rt.string,
  version: rt.string
})]);
exports.AttachmentPatchRequestRt = AttachmentPatchRequestRt;
const AttachmentsFindResponseRt = rt.strict({
  comments: rt.array(_v.AttachmentRt),
  page: rt.number,
  per_page: rt.number,
  total: rt.number
});
exports.AttachmentsFindResponseRt = AttachmentsFindResponseRt;
const FindAttachmentsQueryParamsRt = rt.intersection([rt.exact(rt.partial({
  /**
   * Order to sort the response
   */
  sortOrder: rt.union([rt.literal('desc'), rt.literal('asc')])
})), (0, _schema.paginationSchema)({
  maxPerPage: _constants.MAX_COMMENTS_PER_PAGE
})]);
exports.FindAttachmentsQueryParamsRt = FindAttachmentsQueryParamsRt;
const BulkCreateAttachmentsRequestRt = (0, _schema.limitedArraySchema)({
  codec: AttachmentRequestRt,
  min: 0,
  max: _constants.MAX_BULK_CREATE_ATTACHMENTS,
  fieldName: 'attachments'
});
exports.BulkCreateAttachmentsRequestRt = BulkCreateAttachmentsRequestRt;
const BulkGetAttachmentsRequestRt = rt.strict({
  ids: (0, _schema.limitedArraySchema)({
    codec: rt.string,
    min: 1,
    max: _constants.MAX_BULK_GET_ATTACHMENTS,
    fieldName: 'ids'
  })
});
exports.BulkGetAttachmentsRequestRt = BulkGetAttachmentsRequestRt;
const BulkGetAttachmentsResponseRt = rt.strict({
  attachments: _v.AttachmentsRt,
  errors: rt.array(rt.strict({
    error: rt.string,
    message: rt.string,
    status: rt.union([rt.undefined, rt.number]),
    attachmentId: rt.string
  }))
});
exports.BulkGetAttachmentsResponseRt = BulkGetAttachmentsResponseRt;