"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STACK_APP_ID = exports.FEATURE_ID = exports.CASE_VIEW_TAB_PATH = exports.CASE_VIEW_PATH = exports.CASE_VIEW_COMMENT_PATH = exports.CASE_VIEW_ALERT_TABLE_PATH = exports.CASES_CREATE_PATH = exports.CASES_CONFIGURE_PATH = exports.APP_PATH = exports.APP_OWNER = exports.APP_ID = void 0;
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Application
 */

const APP_ID = 'cases';
exports.APP_ID = APP_ID;
const FEATURE_ID = 'generalCases';
exports.FEATURE_ID = FEATURE_ID;
const APP_OWNER = 'cases';
exports.APP_OWNER = APP_OWNER;
const APP_PATH = '/app/management/insightsAndAlerting/cases';
exports.APP_PATH = APP_PATH;
const CASES_CREATE_PATH = '/create';
exports.CASES_CREATE_PATH = CASES_CREATE_PATH;
const CASES_CONFIGURE_PATH = '/configure';
exports.CASES_CONFIGURE_PATH = CASES_CONFIGURE_PATH;
const CASE_VIEW_PATH = '/:detailName';
exports.CASE_VIEW_PATH = CASE_VIEW_PATH;
const CASE_VIEW_COMMENT_PATH = `${CASE_VIEW_PATH}/:commentId`;
exports.CASE_VIEW_COMMENT_PATH = CASE_VIEW_COMMENT_PATH;
const CASE_VIEW_ALERT_TABLE_PATH = `${CASE_VIEW_PATH}/?tabId=${_types.CASE_VIEW_PAGE_TABS.ALERTS}`;
exports.CASE_VIEW_ALERT_TABLE_PATH = CASE_VIEW_ALERT_TABLE_PATH;
const CASE_VIEW_TAB_PATH = `${CASE_VIEW_PATH}/?tabId=:tabId`;

/**
 * The main Cases application is in the stack management under the
 * Alerts and Insights section. To do that, Cases registers to the management
 * application. This constant holds the application ID of the management plugin
 */
exports.CASE_VIEW_TAB_PATH = CASE_VIEW_TAB_PATH;
const STACK_APP_ID = 'management';
exports.STACK_APP_ID = STACK_APP_ID;