"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getArg = getArg;
exports.getArgs = getArgs;
exports.getError = getError;
exports.getInFlight = getInFlight;
exports.getState = getState;
exports.getValue = getValue;
var _lodash = require("lodash");
var argHelper = _interopRequireWildcard(require("../../lib/resolved_arg"));
var _modify_path = require("../../lib/modify_path");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getArgs(state) {
  return (0, _lodash.get)(state, ['transient', 'resolvedArgs']);
}
function getArg(state, path) {
  return (0, _lodash.get)(state, (0, _modify_path.prepend)(path, ['transient', 'resolvedArgs']));
}
function getValue(state, path) {
  return argHelper.getValue(getArg(state, path));
}
function getState(state, path) {
  return argHelper.getState(getArg(state, path));
}
function getError(state, path) {
  return argHelper.getError(getArg(state, path));
}
function getInFlight(state) {
  return (0, _lodash.get)(state, ['transient', 'inFlight'], false);
}