"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.templateFromReactComponent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _error_boundary = require("../components/enhance/error_boundary");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const templateFromReactComponent = Component => {
  const WrappedComponent = (props, ref) => {
    const [updatedProps, setUpdatedProps] = (0, _react.useState)(props);
    (0, _react.useImperativeHandle)(ref, () => ({
      updateProps: newProps => {
        setUpdatedProps(newProps);
      }
    }));
    return /*#__PURE__*/_react.default.createElement(_error_boundary.ErrorBoundary, null, ({
      error
    }) => {
      if (error) {
        props.renderError();
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(Component, updatedProps));
    });
  };
  const ForwardRefWrappedComponent = /*#__PURE__*/(0, _react.forwardRef)(WrappedComponent);
  ForwardRefWrappedComponent.propTypes = {
    renderError: _propTypes.default.func
  };
  return (domNode, config, handlers, onMount) => {
    try {
      const el = /*#__PURE__*/_react.default.createElement(ForwardRefWrappedComponent, (0, _extends2.default)({}, config, {
        ref: ref => {
          handlers.done();
          onMount === null || onMount === void 0 ? void 0 : onMount(ref);
        }
      }));
      handlers.onDestroy(() => {
        (0, _reactDom.unmountComponentAtNode)(domNode);
      });
      return /*#__PURE__*/(0, _reactDom.createPortal)(el, domNode);
    } catch (err) {
      handlers.done();
      config.renderError();
    }
  };
};
exports.templateFromReactComponent = templateFromReactComponent;