"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.staticWorkpadPagePropTypes = exports.interactiveWorkpadPagePropTypes = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// NOTE: the data-shared-* attributes here are used for reporting

const staticWorkpadPagePropTypes = {
  pageId: _propTypes.default.string.isRequired,
  pageStyle: _propTypes.default.object,
  className: _propTypes.default.string.isRequired,
  animationStyle: _propTypes.default.object.isRequired,
  elements: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    transformMatrix: _propTypes.default.arrayOf(_propTypes.default.number).isRequired,
    width: _propTypes.default.number.isRequired,
    height: _propTypes.default.number.isRequired,
    type: _propTypes.default.string
  })).isRequired,
  height: _propTypes.default.number.isRequired,
  width: _propTypes.default.number.isRequired,
  onAnimationEnd: _propTypes.default.func
};
exports.staticWorkpadPagePropTypes = staticWorkpadPagePropTypes;
const interactiveWorkpadPagePropTypes = {
  ...staticWorkpadPagePropTypes,
  cursor: _propTypes.default.string,
  onDoubleClick: _propTypes.default.func,
  onKeyDown: _propTypes.default.func,
  onMouseDown: _propTypes.default.func,
  onMouseLeave: _propTypes.default.func,
  onMouseMove: _propTypes.default.func,
  onMouseUp: _propTypes.default.func,
  onAnimationEnd: _propTypes.default.func,
  resetHandler: _propTypes.default.func,
  copyElements: _propTypes.default.func,
  cutElements: _propTypes.default.func,
  duplicateElements: _propTypes.default.func,
  pasteElements: _propTypes.default.func,
  removeElements: _propTypes.default.func,
  bringForward: _propTypes.default.func,
  bringToFront: _propTypes.default.func,
  sendBackward: _propTypes.default.func,
  sendToBack: _propTypes.default.func,
  canvasOrigin: _propTypes.default.func,
  saveCanvasOrigin: _propTypes.default.func.isRequired,
  commit: _propTypes.default.func.isRequired,
  setMultiplePositions: _propTypes.default.func.isRequired,
  zoomScale: _propTypes.default.number.isRequired
};
exports.interactiveWorkpadPagePropTypes = interactiveWorkpadPagePropTypes;