"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadPage = exports.ComposedWorkpadPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _recompose = require("recompose");
var _app = require("../../state/selectors/app");
var _workpad = require("../../state/selectors/workpad");
var _functional = require("../../lib/aeroelastic/functional");
var _workpad2 = require("../../routes/workpad");
var _workpad_static_page = require("./workpad_static_page");
var _workpad_interactive_page = require("./workpad_interactive_page");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const animationProps = ({
  animation,
  isSelected
}) => animation ? {
  className: animation.name + ' ' + (isSelected ? 'isActive' : 'isInactive'),
  animationStyle: {
    animationDirection: animation.direction,
    animationDuration: '1s' // TODO: Make this configurable
  }
} : {
  className: isSelected ? 'isActive' : 'isInactive',
  animationStyle: {}
};
const mapStateToProps = (state, {
  isSelected,
  pageId,
  isFullscreen
}) => ({
  isInteractive: isSelected && !isFullscreen && (0, _workpad.isWriteable)(state) && (0, _app.canUserWrite)(state),
  elements: (0, _workpad.getNodes)(state, pageId),
  pageStyle: (0, _workpad.getPageById)(state, pageId).style
});
const ComposedWorkpadPage = (0, _recompose.compose)((0, _recompose.shouldUpdate)((0, _functional.not)(_reactFastCompare.default)),
// this is critical, else random unrelated rerenders in the parent cause glitches here
(0, _recompose.withProps)(animationProps), (0, _reactRedux.connect)(mapStateToProps), (0, _recompose.branch)(({
  isInteractive
}) => isInteractive, _workpad_interactive_page.InteractivePage, _workpad_static_page.StaticPage))();
exports.ComposedWorkpadPage = ComposedWorkpadPage;
const WorkpadPage = props => {
  const {
    isFullscreen
  } = (0, _react.useContext)(_workpad2.WorkpadRoutingContext);
  return /*#__PURE__*/_react.default.createElement(ComposedWorkpadPage, (0, _extends2.default)({}, props, {
    isFullscreen: isFullscreen
  }));
};
exports.WorkpadPage = WorkpadPage;
WorkpadPage.propTypes = {
  pageId: _propTypes.default.string.isRequired
};