"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../i18n/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getDownloadLabel: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.workpadStep.downloadLabel', {
    defaultMessage: 'Download workpad'
  }),
  getStepDescription: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.workpadStep.description', {
    defaultMessage: 'The workpad will be exported as a single {JSON} file for sharing in another site.',
    values: {
      JSON: _constants.JSON
    }
  })
};
const WorkpadStep = ({
  onDownload
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("p", null, strings.getStepDescription()), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  onClick: () => {
    onDownload('share');
  },
  size: "s"
}, strings.getDownloadLabel()));
exports.WorkpadStep = WorkpadStep;