"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LabsControl = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/presentation-util-plugin/public");
var _services = require("../../../services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getLabsButtonLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderLabsControlSettings.labsButtonLabel', {
    defaultMessage: 'Labs'
  })
};
const Flyout = (0, _public.withSuspense)(_public.LazyLabsFlyout, null);
const LabsControl = () => {
  const {
    isLabsEnabled,
    getProjects
  } = (0, _services.useLabsService)();
  const [isShown, setIsShown] = (0, _react.useState)(false);
  if (!isLabsEnabled()) {
    return null;
  }
  const projects = getProjects(['canvas']);
  const overrideCount = Object.values(projects).filter(project => project.status.isOverride).length;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => setIsShown(!isShown),
    size: "xs"
  }, strings.getLabsButtonLabel(), overrideCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    color: "subdued",
    style: {
      marginLeft: 4
    }
  }, overrideCount) : null), isShown ? /*#__PURE__*/_react.default.createElement(Flyout, {
    solutions: ['canvas'],
    onClose: () => setIsShown(false)
  }) : null);
};
exports.LabsControl = LabsControl;