"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadColorPicker = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _workpad = require("../../state/actions/workpad");
var _workpad2 = require("../../state/selectors/workpad");
var _color_picker_popover = require("../color_picker_popover");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getBackgroundColorLabel: () => _i18n.i18n.translate('xpack.canvas.workpadConfig.backgroundColorLabel', {
    defaultMessage: 'Background color'
  })
};
const WorkpadColorPicker = props => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const onAddColor = (0, _react.useCallback)(payload => dispatch((0, _workpad.addColor)(payload)), [dispatch]);
  const onRemoveColor = (0, _react.useCallback)(payload => dispatch((0, _workpad.removeColor)(payload)), [dispatch]);
  const colors = (0, _reactRedux.useSelector)(_workpad2.getWorkpadColors);
  return /*#__PURE__*/_react.default.createElement(_color_picker_popover.ColorPickerPopover, (0, _extends2.default)({}, props, {
    onAddColor: onAddColor,
    onRemoveColor: onRemoveColor,
    colors: colors,
    hasButtons: true,
    ariaLabel: strings.getBackgroundColorLabel()
  }));
};
exports.WorkpadColorPicker = WorkpadColorPicker;
WorkpadColorPicker.propTypes = _color_picker_popover.ColorPickerPopover.propTypes;