"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Workpad = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _workpad_page = require("../workpad_page");
var _fullscreen = require("../fullscreen");
var _constants = require("../../../common/lib/constants");
var _workpad_shortcuts = require("./workpad_shortcuts.component");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error

const Workpad = ({
  fetchAllRenderables,
  getAnimation,
  grid,
  hasHeaderBanner,
  height,
  isFullscreen,
  nextPage,
  onTransitionEnd,
  pages,
  previousPage,
  redoHistory,
  registerLayout,
  resetZoom,
  selectedPageNumber,
  setFullscreen,
  setGrid,
  totalElementCount,
  width,
  workpadCss,
  undoHistory,
  unregisterLayout,
  zoomIn,
  zoomOut,
  zoomScale
}) => {
  const headerBannerOffset = (0, _react.useMemo)(() => {
    if (!hasHeaderBanner) return 0;
    if (typeof document === 'undefined') return 0;

    // Get the banner height from the CSS variable value
    const headerHeightFromCSS = getComputedStyle(document.documentElement).getPropertyValue('--kbnHeaderBannerHeight');
    // Remove the CSS unit
    return parseInt(headerHeightFromCSS, 10);
  }, [hasHeaderBanner]);
  const bufferStyle = {
    height: isFullscreen ? height : (height + 2 * _constants.WORKPAD_CANVAS_BUFFER) * zoomScale,
    width: isFullscreen ? width : (width + 2 * _constants.WORKPAD_CANVAS_BUFFER) * zoomScale
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasWorkpad__buffer",
    style: bufferStyle
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasCheckered",
    style: {
      height,
      width,
      transformOrigin: '0 0',
      transform: isFullscreen ? undefined : `scale3d(${zoomScale}, ${zoomScale}, 1)` // don't scale in fullscreen mode
    }
  }, !isFullscreen && /*#__PURE__*/_react.default.createElement(_workpad_shortcuts.WorkpadShortcuts, {
    fetchAllRenderables: fetchAllRenderables,
    grid: grid,
    isFullscreen: isFullscreen,
    nextPage: nextPage,
    previousPage: previousPage,
    redoHistory: redoHistory,
    resetZoom: resetZoom,
    setFullscreen: setFullscreen,
    setGrid: setGrid,
    undoHistory: undoHistory,
    zoomIn: zoomIn,
    zoomOut: zoomOut
  }), /*#__PURE__*/_react.default.createElement(_fullscreen.Fullscreen, null, ({
    isFullscreen: isFullscreenProp,
    windowSize
  }) => {
    const scale = Math.min((windowSize.height - headerBannerOffset) / height, windowSize.width / width);
    const fsStyle = isFullscreenProp ? {
      transform: `scale3d(${scale}, ${scale}, 1)`,
      WebkitTransform: `scale3d(${scale}, ${scale}, 1)`,
      msTransform: `scale3d(${scale}, ${scale}, 1)`,
      height: windowSize.height < height ? 'auto' : height,
      width: windowSize.width < width ? 'auto' : width,
      top: hasHeaderBanner ? `${headerBannerOffset / 2}px` : undefined
    } : {};

    // NOTE: the data-shared-* attributes here are used for reporting
    return /*#__PURE__*/_react.default.createElement("div", {
      css: (0, _react2.css)(workpadCss || _constants.DEFAULT_WORKPAD_CSS),
      className: `canvasWorkpad ${isFullscreenProp ? 'fullscreen' : ''}`,
      style: fsStyle,
      "data-shared-items-count": totalElementCount
    }, pages.map((page, i) => /*#__PURE__*/_react.default.createElement(_workpad_page.WorkpadPage, {
      key: page.id,
      pageId: page.id,
      height: height,
      width: width,
      isSelected: i + 1 === selectedPageNumber,
      animation: getAnimation(i + 1),
      onAnimationEnd: onTransitionEnd,
      registerLayout: registerLayout,
      unregisterLayout: unregisterLayout
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "canvasGrid",
      style: {
        height,
        width,
        display: grid ? 'block' : 'none'
      }
    }));
  })));
};
exports.Workpad = Workpad;