"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShapePicker = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _shape_preview = require("../shape_preview");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ShapePicker = ({
  shapes,
  onChange = () => {}
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
  gutterSize: "s",
  columns: 4,
  className: "canvasShapePicker"
}, shapes.sort().map(shapeKey => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  key: shapeKey
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  onClick: () => onChange(shapeKey)
}, /*#__PURE__*/_react.default.createElement(_shape_preview.ShapePreview, {
  shape: shapeKey
})))));
exports.ShapePicker = ShapePicker;
ShapePicker.propTypes = {
  onChange: _propTypes.default.func,
  shapes: _propTypes.default.object.isRequired
};