"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useImportWorkpad = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _services = require("../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useImportWorkpad = () => {
  const workpadService = (0, _services.useWorkpadService)();
  const notifyService = (0, _services.useNotifyService)();
  const history = (0, _reactRouterDom.useHistory)();
  return (0, _react.useCallback)(async workpad => {
    try {
      const importedWorkpad = await workpadService.import(workpad);
      history.push(`/workpad/${importedWorkpad.id}/page/1`);
    } catch (err) {
      notifyService.error(err, {
        title: errors.getUploadFailureErrorMessage()
      });
    }
    return;
  }, [notifyService, history, workpadService]);
};
exports.useImportWorkpad = useImportWorkpad;
const errors = {
  getUploadFailureErrorMessage: () => _i18n.i18n.translate('xpack.canvas.error.useUploadWorkpad.uploadFailureErrorMessage', {
    defaultMessage: `Couldn't upload workpad`
  })
};