"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESFieldSelect = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../services");
var _es_field_select = require("./es_field_select");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ESFieldSelect = props => {
  const {
    index,
    value,
    onChange
  } = props;
  const [fields, setFields] = (0, _react.useState)([]);
  const loadingFields = (0, _react.useRef)(false);
  const {
    getFields
  } = (0, _services.useDataViewsService)();
  (0, _react.useEffect)(() => {
    loadingFields.current = true;
    getFields(index).then(newFields => setFields(newFields || [])).finally(() => {
      loadingFields.current = false;
    });
  }, [index, getFields]);
  (0, _react.useEffect)(() => {
    if (!loadingFields.current && value && !fields.includes(value)) {
      onChange(null);
    }
  }, [value, fields, onChange]);
  return /*#__PURE__*/_react.default.createElement(_es_field_select.ESFieldSelect, (0, _extends2.default)({}, props, {
    fields: fields
  }));
};
exports.ESFieldSelect = ESFieldSelect;