"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArgForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _assets = require("../../state/selectors/assets");
var _workpad = require("../../state/selectors/workpad");
var _arg_form = require("./arg_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLabel = (label, argTypeInstance) => label || argTypeInstance.displayName || argTypeInstance.name;
const ArgForm = props => {
  const {
    argTypeInstance,
    label: labelFromProps,
    templateProps
  } = props;
  const [label, setLabel] = (0, _react.useState)(getLabel(labelFromProps, argTypeInstance));
  const [resolvedArgValue, setResolvedArgValue] = (0, _react.useState)(null);
  const workpad = (0, _reactRedux.useSelector)(_workpad.getWorkpadInfo);
  const assets = (0, _reactRedux.useSelector)(_assets.getAssets);
  (0, _react.useEffect)(() => {
    setResolvedArgValue();
  }, [templateProps === null || templateProps === void 0 ? void 0 : templateProps.argValue]);
  return /*#__PURE__*/_react.default.createElement(_arg_form.ArgForm, (0, _extends2.default)({}, props, {
    workpad: workpad,
    assets: assets,
    label: label,
    setLabel: setLabel,
    resolvedArgValue: resolvedArgValue,
    setResolvedArgValue: setResolvedArgValue
  }));
};
exports.ArgForm = ArgForm;
ArgForm.propTypes = {
  label: _propTypes.default.string,
  argTypeInstance: _propTypes.default.shape({
    name: _propTypes.default.string.isRequired,
    displayName: _propTypes.default.string,
    expanded: _propTypes.default.bool
  }).isRequired
};