"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PublicAssetsClient = void 0;
var _constants_routes = require("../../common/constants_routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class PublicAssetsClient {
  constructor(http) {
    this.http = http;
  }
  async getHosts(options) {
    const {
      filters,
      ...otherOptions
    } = options;
    const results = await this.http.get(_constants_routes.GET_HOSTS, {
      query: {
        stringFilters: JSON.stringify(filters),
        ...otherOptions
      }
    });
    return results;
  }
  async getContainers(options) {
    const {
      filters,
      ...otherOptions
    } = options;
    const results = await this.http.get(_constants_routes.GET_CONTAINERS, {
      query: {
        stringFilters: JSON.stringify(filters),
        ...otherOptions
      }
    });
    return results;
  }
  async getServices(options) {
    const {
      filters,
      ...otherOptions
    } = options;
    const results = await this.http.get(_constants_routes.GET_SERVICES, {
      query: {
        stringFilters: JSON.stringify(filters),
        ...otherOptions
      }
    });
    return results;
  }
  async getPods(options) {
    const {
      filters,
      ...otherOptions
    } = options;
    const results = await this.http.get(_constants_routes.GET_PODS, {
      query: {
        stringFilters: JSON.stringify(filters),
        ...otherOptions
      }
    });
    return results;
  }
  async getAssets(options) {
    const {
      filters,
      ...otherOptions
    } = options;
    const results = await this.http.get(_constants_routes.GET_ASSETS, {
      query: {
        stringFilters: JSON.stringify(filters),
        ...otherOptions
      }
    });
    return results;
  }
}
exports.PublicAssetsClient = PublicAssetsClient;