"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sizeRT = exports.relationRT = exports.getServiceAssetsResponseRT = exports.getServiceAssetsQueryOptionsRT = exports.getPodAssetsResponseRT = exports.getPodAssetsQueryOptionsRT = exports.getHostAssetsResponseRT = exports.getHostAssetsQueryOptionsRT = exports.getContainerAssetsResponseRT = exports.getContainerAssetsQueryOptionsRT = exports.getAssetsResponseRT = exports.getAssetsQueryOptionsRT = exports.cloudProviderNameRT = exports.assetTypeRT = exports.assetStatusRT = exports.assetRT = exports.assetKindRT = exports.assetFiltersSingleKindRT = exports.assetFiltersRT = exports.assetDateRT = exports.ECSDocumentRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _ioTsUtils = require("@kbn/io-ts-utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assetTypeRT = rt.keyof({
  'k8s.pod': null,
  'k8s.cluster': null,
  'k8s.node': null
});
exports.assetTypeRT = assetTypeRT;
const assetKindRT = rt.keyof({
  cluster: null,
  host: null,
  pod: null,
  container: null,
  service: null
});
exports.assetKindRT = assetKindRT;
const assetStatusRT = rt.keyof({
  CREATING: null,
  ACTIVE: null,
  DELETING: null,
  FAILED: null,
  UPDATING: null,
  PENDING: null,
  UNKNOWN: null
});
exports.assetStatusRT = assetStatusRT;
// https://github.com/gcanti/io-ts/blob/master/index.md#union-of-string-literals
const cloudProviderNameRT = rt.keyof({
  aws: null,
  gcp: null,
  azure: null,
  other: null,
  unknown: null,
  none: null
});
exports.cloudProviderNameRT = cloudProviderNameRT;
const withTimestampRT = rt.type({
  '@timestamp': rt.string
});
const ECSDocumentRT = rt.intersection([withTimestampRT, rt.partial({
  'kubernetes.namespace': rt.string,
  'kubernetes.pod.name': rt.string,
  'kubernetes.pod.uid': rt.string,
  'kubernetes.pod.start_time': rt.string,
  'kubernetes.node.name': rt.string,
  'kubernetes.node.start_time': rt.string,
  'orchestrator.api_version': rt.string,
  'orchestrator.namespace': rt.string,
  'orchestrator.organization': rt.string,
  'orchestrator.type': rt.string,
  'orchestrator.cluster.id': rt.string,
  'orchestrator.cluster.name': rt.string,
  'orchestrator.cluster.url': rt.string,
  'orchestrator.cluster.version': rt.string,
  'cloud.provider': cloudProviderNameRT,
  'cloud.instance.id': rt.string,
  'cloud.region': rt.string,
  'cloud.service.name': rt.string,
  'service.environment': rt.string
})]);
exports.ECSDocumentRT = ECSDocumentRT;
const assetRT = rt.intersection([ECSDocumentRT, rt.type({
  'asset.ean': rt.string,
  'asset.id': rt.string,
  'asset.kind': assetKindRT
}),
// mixed required and optional require separate hashes combined via intersection
// https://github.com/gcanti/io-ts/blob/master/index.md#mixing-required-and-optional-props
rt.partial({
  'asset.collection_version': rt.string,
  'asset.name': rt.string,
  'asset.type': assetTypeRT,
  'asset.status': assetStatusRT,
  'asset.parents': rt.union([rt.string, rt.array(rt.string)]),
  'asset.children': rt.union([rt.string, rt.array(rt.string)]),
  'asset.references': rt.union([rt.string, rt.array(rt.string)]),
  'asset.namespace': rt.string
})]);
exports.assetRT = assetRT;
const assetFiltersSingleKindRT = rt.exact(rt.partial({
  type: rt.union([assetTypeRT, rt.array(assetTypeRT)]),
  ean: rt.union([rt.string, rt.array(rt.string)]),
  id: rt.string,
  parentEan: rt.string,
  ['cloud.provider']: rt.string,
  ['cloud.region']: rt.string,
  ['orchestrator.cluster.name']: rt.string
}));
exports.assetFiltersSingleKindRT = assetFiltersSingleKindRT;
const supportedKindRT = rt.union([rt.literal('host'), rt.literal('service')]);
const assetFiltersRT = rt.intersection([assetFiltersSingleKindRT, rt.partial({
  kind: rt.union([supportedKindRT, rt.array(supportedKindRT)])
})]);
exports.assetFiltersRT = assetFiltersRT;
const relationRT = rt.union([rt.literal('ancestors'), rt.literal('descendants'), rt.literal('references')]);
exports.relationRT = relationRT;
const sizeRT = rt.union([(0, _ioTsUtils.inRangeFromStringRt)(1, 100), (0, _ioTsUtils.createLiteralValueFromUndefinedRT)(10)]);
exports.sizeRT = sizeRT;
const assetDateRT = rt.union([_ioTsUtils.dateRt, _ioTsUtils.datemathStringRt]);

/**
 * Hosts
 */
exports.assetDateRT = assetDateRT;
const getHostAssetsQueryOptionsRT = rt.intersection([rt.strict({
  from: assetDateRT
}), rt.partial({
  to: assetDateRT,
  size: sizeRT,
  stringFilters: rt.string,
  filters: assetFiltersSingleKindRT
})]);
exports.getHostAssetsQueryOptionsRT = getHostAssetsQueryOptionsRT;
const getHostAssetsResponseRT = rt.type({
  hosts: rt.array(assetRT)
});
exports.getHostAssetsResponseRT = getHostAssetsResponseRT;
/**
 * Containers
 */
const getContainerAssetsQueryOptionsRT = rt.intersection([rt.strict({
  from: assetDateRT
}), rt.partial({
  to: assetDateRT,
  size: sizeRT,
  stringFilters: rt.string,
  filters: assetFiltersSingleKindRT
})]);
exports.getContainerAssetsQueryOptionsRT = getContainerAssetsQueryOptionsRT;
const getContainerAssetsResponseRT = rt.type({
  containers: rt.array(assetRT)
});
exports.getContainerAssetsResponseRT = getContainerAssetsResponseRT;
/**
 * Services
 */
const getServiceAssetsQueryOptionsRT = rt.intersection([rt.strict({
  from: assetDateRT
}), rt.partial({
  from: assetDateRT,
  to: assetDateRT,
  size: sizeRT,
  stringFilters: rt.string,
  filters: assetFiltersSingleKindRT
})]);
exports.getServiceAssetsQueryOptionsRT = getServiceAssetsQueryOptionsRT;
const getServiceAssetsResponseRT = rt.type({
  services: rt.array(assetRT)
});
exports.getServiceAssetsResponseRT = getServiceAssetsResponseRT;
/**
 * Pods
 */
const getPodAssetsQueryOptionsRT = rt.intersection([rt.strict({
  from: assetDateRT
}), rt.partial({
  to: assetDateRT,
  size: sizeRT,
  stringFilters: rt.string,
  filters: assetFiltersSingleKindRT
})]);
exports.getPodAssetsQueryOptionsRT = getPodAssetsQueryOptionsRT;
const getPodAssetsResponseRT = rt.type({
  pods: rt.array(assetRT)
});
exports.getPodAssetsResponseRT = getPodAssetsResponseRT;
/**
 * Assets
 */
const getAssetsQueryOptionsRT = rt.intersection([rt.strict({
  from: assetDateRT
}), rt.partial({
  to: assetDateRT,
  size: sizeRT,
  stringFilters: rt.string,
  filters: assetFiltersRT
})]);
exports.getAssetsQueryOptionsRT = getAssetsQueryOptionsRT;
const getAssetsResponseRT = rt.type({
  assets: rt.array(assetRT)
});
exports.getAssetsResponseRT = getAssetsResponseRT;