"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getThroughput = getThroughput;
var _server = require("@kbn/observability-plugin/server");
var _apm = require("../../../common/es_fields/apm");
var _environment_query = require("../../../common/utils/environment_query");
var _get_offset_in_ms = require("../../../common/utils/get_offset_in_ms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getThroughput({
  environment,
  kuery,
  serviceName,
  apmEventClient,
  transactionType,
  transactionName,
  start,
  end,
  offset,
  documentType,
  rollupInterval,
  bucketSizeInSeconds
}) {
  var _response$aggregation, _response$aggregation2;
  const {
    startWithOffset,
    endWithOffset
  } = (0, _get_offset_in_ms.getOffsetInMs)({
    start,
    end,
    offset
  });
  const params = {
    apm: {
      sources: [{
        documentType,
        rollupInterval
      }]
    },
    body: {
      track_total_hits: false,
      size: 0,
      query: {
        bool: {
          filter: [{
            term: {
              [_apm.SERVICE_NAME]: serviceName
            }
          }, {
            term: {
              [_apm.TRANSACTION_TYPE]: transactionType
            }
          }, ...(0, _server.rangeQuery)(startWithOffset, endWithOffset), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery), ...(0, _server.termQuery)(_apm.TRANSACTION_NAME, transactionName)]
        }
      },
      aggs: {
        timeseries: {
          date_histogram: {
            field: '@timestamp',
            fixed_interval: `${bucketSizeInSeconds}s`,
            min_doc_count: 0,
            extended_bounds: {
              min: startWithOffset,
              max: endWithOffset
            }
          },
          aggs: {
            throughput: {
              rate: {
                unit: 'minute'
              }
            }
          }
        }
      }
    }
  };
  const response = await apmEventClient.search('get_throughput_for_service', params);
  return (_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.timeseries.buckets.map(bucket => {
    return {
      x: bucket.key,
      y: bucket.throughput.value
    };
  })) !== null && _response$aggregation !== void 0 ? _response$aggregation : [];
}