"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexTemplatesByIndexPattern = getIndexTemplatesByIndexPattern;
var _lodash = require("lodash");
var _elasticsearch = require("@elastic/elasticsearch");
var _get_indices = require("./get_indices");
var _get_index_template = require("./get_index_template");
var _get_apm_index_template_names = require("../helpers/get_apm_index_template_names");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getIndexTemplatesByIndexPattern({
  esClient,
  apmIndices
}) {
  const indexPatterns = (0, _get_indices.getApmIndexPatterns)([apmIndices.error, apmIndices.metric, apmIndices.span, apmIndices.transaction]);
  return await handleInvalidIndexTemplateException(Promise.all(indexPatterns.map(async indexPattern => getSimulatedIndexTemplateForIndexPattern({
    indexPattern,
    esClient
  }))));
}
async function getSimulatedIndexTemplateForIndexPattern({
  esClient,
  indexPattern
}) {
  var _simulatedIndexTempla;
  const simulatedIndexTemplate = await esClient.transport.request({
    method: 'POST',
    path: '/_index_template/_simulate',
    body: {
      index_patterns: [indexPattern]
    }
  });
  const indexTemplates = await Promise.all(((_simulatedIndexTempla = simulatedIndexTemplate.overlapping) !== null && _simulatedIndexTempla !== void 0 ? _simulatedIndexTempla : []).map(async ({
    index_patterns: templateIndexPatterns,
    name: templateName
  }) => {
    const priority = await getTemplatePriority(esClient, templateName);
    const isNonStandard = getIsNonStandardIndexTemplate(templateName);
    return {
      isNonStandard,
      priority,
      templateIndexPatterns,
      templateName
    };
  }));
  return {
    indexPattern,
    indexTemplates: (0, _lodash.orderBy)(indexTemplates, ({
      priority
    }) => priority, 'desc')
  };
}
async function getTemplatePriority(esClient, name) {
  var _res$index_templates$, _res$index_templates$2;
  const res = await (0, _get_index_template.getIndexTemplate)(esClient, {
    name
  });
  return (_res$index_templates$ = res.index_templates[0]) === null || _res$index_templates$ === void 0 ? void 0 : (_res$index_templates$2 = _res$index_templates$.index_template) === null || _res$index_templates$2 === void 0 ? void 0 : _res$index_templates$2.priority;
}
function getIsNonStandardIndexTemplate(templateName) {
  const apmIndexTemplateNames = (0, _get_apm_index_template_names.getApmIndexTemplateNames)();
  const stackIndexTemplateNames = ['logs', 'metrics'];
  const isNonStandard = [...apmIndexTemplateNames, ...stackIndexTemplateNames].every(apmIndexTemplateName => {
    const notMatch = templateName !== apmIndexTemplateName;
    return notMatch;
  });
  return isNonStandard;
}
async function handleInvalidIndexTemplateException(promise) {
  try {
    return await promise;
  } catch (error) {
    if (error instanceof _elasticsearch.errors.ResponseError && error.meta.statusCode === 400 &&
    // @ts-expect-error
    error.meta.body.error.type === 'invalid_index_template_exception') {
      console.error(`Suppressed exception caused by cross cluster search: ${error.message}}`);
      return [];
    }
    console.error(`Suppressed unknown exception: ${error.message}`);
    return [];
  }
}