"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceDashboardsRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _save_service_dashboard = require("./save_service_dashboard");
var _remove_service_dashboard = require("./remove_service_dashboard");
var _get_custom_dashboards = require("./get_custom_dashboards");
var _get_services_with_dashboards = require("./get_services_with_dashboards");
var _get_apm_event_client = require("../../lib/helpers/get_apm_event_client");
var _default_api_types = require("../default_api_types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const serviceDashboardSaveRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'POST /internal/apm/custom-dashboard',
  params: t.type({
    query: t.union([t.partial({
      customDashboardId: t.string
    }), t.undefined]),
    body: t.type({
      dashboardSavedObjectId: t.string,
      kuery: t.union([t.string, t.undefined]),
      serviceNameFilterEnabled: t.boolean,
      serviceEnvironmentFilterEnabled: t.boolean
    })
  }),
  options: {
    tags: ['access:apm', 'access:apm_write']
  },
  handler: async resources => {
    const {
      context,
      params
    } = resources;
    const {
      customDashboardId
    } = params.query;
    const {
      savedObjects: {
        client: savedObjectsClient
      }
    } = await context.core;
    return (0, _save_service_dashboard.saveServiceDashbord)({
      savedObjectsClient,
      customDashboardId,
      serviceDashboard: params.body
    });
  }
});
const serviceDashboardsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/dashboards',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: _default_api_types.rangeRt
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const {
      context,
      params
    } = resources;
    const {
      start,
      end
    } = params.query;
    const {
      serviceName
    } = params.path;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      savedObjects: {
        client: savedObjectsClient
      }
    } = await context.core;
    const allLinkedCustomDashboards = await (0, _get_custom_dashboards.getCustomDashboards)({
      savedObjectsClient
    });
    const servicesWithDashboards = await (0, _get_services_with_dashboards.getServicesWithDashboards)({
      apmEventClient,
      allLinkedCustomDashboards,
      serviceName,
      start,
      end
    });
    return {
      serviceDashboards: servicesWithDashboards
    };
  }
});
const serviceDashboardDeleteRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'DELETE /internal/apm/custom-dashboard',
  params: t.type({
    query: t.type({
      customDashboardId: t.string
    })
  }),
  options: {
    tags: ['access:apm', 'access:apm_write']
  },
  handler: async resources => {
    const {
      context,
      params
    } = resources;
    const {
      customDashboardId
    } = params.query;
    const savedObjectsClient = (await context.core).savedObjects.client;
    await (0, _remove_service_dashboard.deleteServiceDashboard)({
      savedObjectsClient,
      customDashboardId
    });
  }
});
const serviceDashboardsRouteRepository = {
  ...serviceDashboardSaveRoute,
  ...serviceDashboardDeleteRoute,
  ...serviceDashboardsRoute
};
exports.serviceDashboardsRouteRepository = serviceDashboardsRouteRepository;