"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmTimeseriesType = void 0;
exports.getApmTimeseries = getApmTimeseries;
exports.getApmTimeseriesRt = void 0;
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _server = require("@kbn/observability-plugin/server");
var t = _interopRequireWildcard(require("io-ts"));
var _apm = require("../../../../common/es_fields/apm");
var _latency_aggregation_types = require("../../../../common/latency_aggregation_types");
var _environment_query = require("../../../../common/utils/environment_query");
var _get_bucket_size = require("../../../../common/utils/get_bucket_size");
var _term_query = require("../../../../common/utils/term_query");
var _get_error_event_rate = require("./get_error_event_rate");
var _get_exit_span_failure_rate = require("./get_exit_span_failure_rate");
var _get_exit_span_latency = require("./get_exit_span_latency");
var _get_exit_span_throughput = require("./get_exit_span_throughput");
var _get_transaction_failure_rate = require("./get_transaction_failure_rate");
var _get_transaction_latency = require("./get_transaction_latency");
var _get_transaction_throughput = require("./get_transaction_throughput");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ApmTimeseriesType;
exports.ApmTimeseriesType = ApmTimeseriesType;
(function (ApmTimeseriesType) {
  ApmTimeseriesType["transactionThroughput"] = "transaction_throughput";
  ApmTimeseriesType["transactionLatency"] = "transaction_latency";
  ApmTimeseriesType["transactionFailureRate"] = "transaction_failure_rate";
  ApmTimeseriesType["exitSpanThroughput"] = "exit_span_throughput";
  ApmTimeseriesType["exitSpanLatency"] = "exit_span_latency";
  ApmTimeseriesType["exitSpanFailureRate"] = "exit_span_failure_rate";
  ApmTimeseriesType["errorEventRate"] = "error_event_rate";
})(ApmTimeseriesType || (exports.ApmTimeseriesType = ApmTimeseriesType = {}));
const getApmTimeseriesRt = t.type({
  stats: t.array(t.intersection([t.type({
    'service.name': t.string,
    title: t.string,
    timeseries: t.union([t.intersection([t.type({
      name: t.union([t.literal(ApmTimeseriesType.transactionThroughput), t.literal(ApmTimeseriesType.transactionFailureRate)])
    }), t.partial({
      'transaction.type': t.string
    })]), t.intersection([t.type({
      name: t.union([t.literal(ApmTimeseriesType.exitSpanThroughput), t.literal(ApmTimeseriesType.exitSpanFailureRate), t.literal(ApmTimeseriesType.exitSpanLatency)])
    }), t.partial({
      'span.destination.service.resource': t.string
    })]), t.intersection([t.type({
      name: t.literal(ApmTimeseriesType.transactionLatency),
      function: t.union([t.literal(_latency_aggregation_types.LatencyAggregationType.avg), t.literal(_latency_aggregation_types.LatencyAggregationType.p95), t.literal(_latency_aggregation_types.LatencyAggregationType.p99)])
    }), t.partial({
      'transaction.type': t.string
    })]), t.type({
      name: t.literal(ApmTimeseriesType.errorEventRate)
    })])
  }), t.partial({
    filter: t.string,
    offset: t.string,
    'service.environment': t.string
  })])),
  start: t.string,
  end: t.string
});
exports.getApmTimeseriesRt = getApmTimeseriesRt;
async function getApmTimeseries({
  arguments: args,
  apmEventClient
}) {
  const start = _datemath.default.parse(args.start).valueOf();
  const end = _datemath.default.parse(args.end).valueOf();
  const {
    bucketSize,
    intervalString
  } = (0, _get_bucket_size.getBucketSize)({
    start,
    end,
    numBuckets: 100
  });
  const sharedParameters = {
    apmEventClient,
    start,
    end,
    bucketSize,
    intervalString
  };
  return (await Promise.all(args.stats.map(async stat => {
    const parameters = {
      ...sharedParameters,
      filter: [...(0, _server.rangeQuery)(start, end), ...(0, _term_query.termQuery)(_apm.SERVICE_NAME, stat['service.name']), ...(0, _server.kqlQuery)(stat.filter), ...(0, _environment_query.environmentQuery)(stat['service.environment'])]
    };
    const name = stat.timeseries.name;
    async function fetchSeriesForStat() {
      switch (name) {
        case ApmTimeseriesType.transactionThroughput:
          return await (0, _get_transaction_throughput.getTransactionThroughput)({
            ...parameters,
            transactionType: stat.timeseries['transaction.type']
          });
        case ApmTimeseriesType.transactionFailureRate:
          return await (0, _get_transaction_failure_rate.getTransactionFailureRate)({
            ...parameters,
            transactionType: stat.timeseries['transaction.type']
          });
        case ApmTimeseriesType.transactionLatency:
          return await (0, _get_transaction_latency.getTransactionLatency)({
            ...parameters,
            transactionType: stat.timeseries['transaction.type'],
            latencyAggregationType: stat.timeseries.function
          });
        case ApmTimeseriesType.exitSpanThroughput:
          return await (0, _get_exit_span_throughput.getExitSpanThroughput)({
            ...parameters,
            spanDestinationServiceResource: stat.timeseries['span.destination.service.resource']
          });
        case ApmTimeseriesType.exitSpanFailureRate:
          return await (0, _get_exit_span_failure_rate.getExitSpanFailureRate)({
            ...parameters,
            spanDestinationServiceResource: stat.timeseries['span.destination.service.resource']
          });
        case ApmTimeseriesType.exitSpanLatency:
          return await (0, _get_exit_span_latency.getExitSpanLatency)({
            ...parameters,
            spanDestinationServiceResource: stat.timeseries['span.destination.service.resource']
          });
        case ApmTimeseriesType.errorEventRate:
          return await (0, _get_error_event_rate.getErrorEventRate)(parameters);
      }
    }
    const allFetchedSeries = await fetchSeriesForStat();
    return allFetchedSeries.map(series => ({
      ...series,
      stat
    }));
  }))).flatMap(statResults => statResults.flatMap(statResult => {
    var _Object$keys, _statResult$change_po, _statResult$change_po2, _statResult$change_po3;
    const changePointType = (_Object$keys = Object.keys((_statResult$change_po = (_statResult$change_po2 = statResult.change_point) === null || _statResult$change_po2 === void 0 ? void 0 : _statResult$change_po2.type) !== null && _statResult$change_po !== void 0 ? _statResult$change_po : {})) === null || _Object$keys === void 0 ? void 0 : _Object$keys[0];
    return {
      stat: statResult.stat,
      group: statResult.stat.title,
      id: statResult.groupBy,
      data: statResult.data,
      value: statResult.value,
      start,
      end,
      unit: statResult.unit,
      changes: [...(changePointType && changePointType !== 'indeterminable' ? [{
        date: (_statResult$change_po3 = statResult.change_point.bucket) === null || _statResult$change_po3 === void 0 ? void 0 : _statResult$change_po3.key,
        type: changePointType,
        ...statResult.change_point.type[changePointType]
      }] : [])]
    };
  }));
}