"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmServiceSummary = getApmServiceSummary;
exports.serviceSummaryRouteRt = void 0;
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _server = require("@kbn/observability-plugin/server");
var _technical_rule_data_field_names = require("@kbn/rule-registry-plugin/common/technical_rule_data_field_names");
var t = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
var _apm_ml_detectors = require("../../../../common/anomaly_detection/apm_ml_detectors");
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _apm = require("../../../../common/es_fields/apm");
var _as_mutable_array = require("../../../../common/utils/as_mutable_array");
var _environment_query = require("../../../../common/utils/environment_query");
var _maybe = require("../../../../common/utils/maybe");
var _term_query = require("../../../../common/utils/term_query");
var _anomaly_search = require("../../../lib/anomaly_detection/anomaly_search");
var _apm_ml_anomaly_query = require("../../../lib/anomaly_detection/apm_ml_anomaly_query");
var _apm_ml_jobs_query = require("../../../lib/anomaly_detection/apm_ml_jobs_query");
var _get_ml_jobs_with_apm_group = require("../../../lib/anomaly_detection/get_ml_jobs_with_apm_group");
var _get_environments = require("../../environments/get_environments");
var _annotations = require("../../services/annotations");
var _get_service_metadata_details = require("../../services/get_service_metadata_details");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const serviceSummaryRouteRt = t.intersection([t.type({
  'service.name': t.string,
  start: t.string,
  end: t.string
}), t.partial({
  'service.environment': t.string,
  'transaction.type': t.string
})]);
exports.serviceSummaryRouteRt = serviceSummaryRouteRt;
async function getAnomalies({
  serviceName,
  transactionType,
  environment,
  start,
  end,
  mlClient,
  logger
}) {
  var _anomaliesResponse$ag;
  if (!mlClient) {
    return [];
  }
  const mlJobs = (await (0, _get_ml_jobs_with_apm_group.getMlJobsWithAPMGroup)(mlClient.anomalyDetectors)).filter(job => job.environment !== environment);
  if (!mlJobs.length) {
    return [];
  }
  const anomaliesResponse = await (0, _anomaly_search.anomalySearch)(mlClient.mlSystem.mlAnomalySearch, {
    body: {
      size: 0,
      query: {
        bool: {
          filter: [...(0, _apm_ml_anomaly_query.apmMlAnomalyQuery)({
            serviceName,
            transactionType
          }), ...(0, _server.rangeQuery)(start, end, 'timestamp'), ...(0, _apm_ml_jobs_query.apmMlJobsQuery)(mlJobs)]
        }
      },
      aggs: {
        by_timeseries_id: {
          composite: {
            size: 5000,
            sources: (0, _as_mutable_array.asMutableArray)([{
              jobId: {
                terms: {
                  field: 'job_id'
                }
              }
            }, {
              detectorIndex: {
                terms: {
                  field: 'detector_index'
                }
              }
            }, {
              serviceName: {
                terms: {
                  field: 'partition_field_value'
                }
              }
            }, {
              transactionType: {
                terms: {
                  field: 'by_field_value'
                }
              }
            }])
          },
          aggs: {
            record_scores: {
              filter: {
                term: {
                  result_type: 'record'
                }
              },
              aggs: {
                top_anomaly: {
                  top_metrics: {
                    metrics: (0, _as_mutable_array.asMutableArray)([{
                      field: 'record_score'
                    }, {
                      field: 'actual'
                    }, {
                      field: 'timestamp'
                    }]),
                    size: 1,
                    sort: {
                      record_score: 'desc'
                    }
                  }
                }
              }
            },
            model_lower: {
              min: {
                field: 'model_lower'
              }
            },
            model_upper: {
              max: {
                field: 'model_upper'
              }
            }
          }
        }
      }
    }
  });
  const jobsById = (0, _lodash.keyBy)(mlJobs, job => job.jobId);
  const anomalies = (_anomaliesResponse$ag = anomaliesResponse.aggregations) === null || _anomaliesResponse$ag === void 0 ? void 0 : _anomaliesResponse$ag.by_timeseries_id.buckets.map(bucket => {
    var _bucket$record_scores;
    const jobId = bucket.key.jobId;
    const job = (0, _maybe.maybe)(jobsById[jobId]);
    if (!job) {
      logger.warn(`Could not find job for id ${jobId}`);
      return undefined;
    }
    const type = (0, _apm_ml_detectors.getApmMlDetectorType)(Number(bucket.key.detectorIndex));

    // ml failure rate is stored as 0-100, we calculate failure rate as 0-1
    const divider = type === _apm_ml_detectors.ApmMlDetectorType.txFailureRate ? 100 : 1;
    const metrics = (_bucket$record_scores = bucket.record_scores.top_anomaly.top[0]) === null || _bucket$record_scores === void 0 ? void 0 : _bucket$record_scores.metrics;
    if (!metrics) {
      return undefined;
    }
    return {
      '@timestamp': new Date(metrics.timestamp).toISOString(),
      metricName: type.replace('tx', 'transaction'),
      'service.name': bucket.key.serviceName,
      'service.environment': job.environment,
      'transaction.type': bucket.key.transactionType,
      anomalyScore: metrics.record_score,
      actualValue: Number(metrics.actual) / divider,
      expectedBoundsLower: Number(bucket.model_lower.value) / divider,
      expectedBoundsUpper: Number(bucket.model_upper.value) / divider
    };
  });
  return (0, _lodash.compact)(anomalies);
}
async function getApmServiceSummary({
  arguments: args,
  apmEventClient,
  mlClient,
  esClient,
  annotationsClient,
  apmAlertsClient,
  logger
}) {
  var _datemath$parse, _datemath$parse2, _metadataDetails$serv, _metadataDetails$serv2, _metadataDetails$serv3, _metadataDetails$serv4, _metadataDetails$cont, _metadataDetails$cont2;
  const start = (_datemath$parse = _datemath.default.parse(args.start)) === null || _datemath$parse === void 0 ? void 0 : _datemath$parse.valueOf();
  const end = (_datemath$parse2 = _datemath.default.parse(args.end)) === null || _datemath$parse2 === void 0 ? void 0 : _datemath$parse2.valueOf();
  const serviceName = args['service.name'];
  const environment = args['service.environment'] || _environment_filter_values.ENVIRONMENT_ALL.value;
  const transactionType = args['transaction.type'];
  const [environments, metadataDetails, anomalies, annotations, alerts] = await Promise.all([environment === _environment_filter_values.ENVIRONMENT_ALL.value ? (0, _get_environments.getEnvironments)({
    apmEventClient,
    start,
    end,
    size: 10,
    serviceName,
    searchAggregatedTransactions: true
  }) : Promise.resolve([environment]), (0, _get_service_metadata_details.getServiceMetadataDetails)({
    apmEventClient,
    start,
    end,
    serviceName,
    environment
  }), getAnomalies({
    serviceName,
    start,
    end,
    environment,
    mlClient,
    logger,
    transactionType
  }), (0, _annotations.getServiceAnnotations)({
    apmEventClient,
    start,
    end,
    searchAggregatedTransactions: true,
    client: esClient,
    annotationsClient,
    environment,
    logger,
    serviceName
  }), apmAlertsClient.search({
    size: 100,
    track_total_hits: false,
    body: {
      query: {
        bool: {
          filter: [...(0, _term_query.termQuery)(_technical_rule_data_field_names.ALERT_RULE_PRODUCER, 'apm'), ...(0, _term_query.termQuery)(_technical_rule_data_field_names.ALERT_STATUS, _technical_rule_data_field_names.ALERT_STATUS_ACTIVE), ...(0, _server.rangeQuery)(start, end), ...(0, _term_query.termQuery)(_apm.SERVICE_NAME, serviceName), ...(0, _environment_query.environmentQuery)(environment)]
        }
      }
    }
  })]);
  return {
    'service.name': serviceName,
    'service.environment': environments,
    'agent.name': (_metadataDetails$serv = metadataDetails.service) === null || _metadataDetails$serv === void 0 ? void 0 : _metadataDetails$serv.agent.name,
    'service.version': (_metadataDetails$serv2 = metadataDetails.service) === null || _metadataDetails$serv2 === void 0 ? void 0 : _metadataDetails$serv2.versions,
    'language.name': (_metadataDetails$serv3 = metadataDetails.service) === null || _metadataDetails$serv3 === void 0 ? void 0 : _metadataDetails$serv3.agent.name,
    'service.framework': (_metadataDetails$serv4 = metadataDetails.service) === null || _metadataDetails$serv4 === void 0 ? void 0 : _metadataDetails$serv4.framework,
    instances: (_metadataDetails$cont = (_metadataDetails$cont2 = metadataDetails.container) === null || _metadataDetails$cont2 === void 0 ? void 0 : _metadataDetails$cont2.totalNumberInstances) !== null && _metadataDetails$cont !== void 0 ? _metadataDetails$cont : 1,
    anomalies,
    alerts: alerts.hits.hits.map(alert => {
      var _alert$_source, _alert$_source2;
      return {
        type: (_alert$_source = alert._source) === null || _alert$_source === void 0 ? void 0 : _alert$_source['kibana.alert.rule.type'],
        started: new Date((_alert$_source2 = alert._source) === null || _alert$_source2 === void 0 ? void 0 : _alert$_source2['kibana.alert.start']).toISOString()
      };
    }),
    deployments: annotations.annotations.map(annotation => ({
      '@timestamp': new Date(annotation['@timestamp']).toISOString()
    }))
  };
}