"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.errorRouteRt = void 0;
exports.getApmErrorDocument = getApmErrorDocument;
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _server = require("@kbn/observability-plugin/server");
var t = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
var _document_type = require("../../../../common/document_type");
var _rollup = require("../../../../common/rollup");
var _term_query = require("../../../../common/utils/term_query");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const errorRouteRt = t.intersection([t.type({
  start: t.string,
  end: t.string
}), t.partial({
  'error.grouping_name': t.string,
  'service.name': t.string
})]);
exports.errorRouteRt = errorRouteRt;
async function getApmErrorDocument({
  arguments: args,
  apmEventClient
}) {
  var _datemath$parse, _datemath$parse2, _response$aggregation, _response$aggregation2;
  const start = (_datemath$parse = _datemath.default.parse(args.start)) === null || _datemath$parse === void 0 ? void 0 : _datemath$parse.valueOf();
  const end = (_datemath$parse2 = _datemath.default.parse(args.end)) === null || _datemath$parse2 === void 0 ? void 0 : _datemath$parse2.valueOf();
  const response = await apmEventClient.search('get_error', {
    apm: {
      sources: [{
        documentType: _document_type.ApmDocumentType.ErrorEvent,
        rollupInterval: _rollup.RollupInterval.None
      }]
    },
    body: {
      track_total_hits: false,
      query: {
        bool: {
          filter: [...(0, _server.rangeQuery)(start, end), ...(0, _term_query.termQuery)('error.grouping_name', args['error.grouping_name']), ...(0, _term_query.termQuery)('service.name', args['service.name'])]
        }
      },
      size: 0,
      aggs: {
        errorGroups: {
          terms: {
            field: 'error.grouping_name',
            size: 5
          },
          aggs: {
            sample: {
              top_hits: {
                size: 1
              }
            }
          }
        }
      }
    }
  });
  return (_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.errorGroups.buckets.map(bucket => {
    const source = bucket.sample.hits.hits[0]._source;
    const formattedResponse = (0, _lodash.pick)(source, 'message', 'error', '@timestamp', 'transaction.name', 'transaction.type', 'span.name', 'span.type', 'span.subtype');
    return formattedResponse;
  })) !== null && _response$aggregation !== void 0 ? _response$aggregation : [];
}