"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerTransactionErrorRateRuleType = registerTransactionErrorRateRuleType;
exports.transactionErrorRateActionVariables = void 0;
var _server = require("@kbn/core/server");
var _common = require("@kbn/observability-plugin/common");
var _formatters = require("@kbn/observability-plugin/common/utils/formatters");
var _server2 = require("@kbn/observability-plugin/server");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _server3 = require("@kbn/rule-registry-plugin/server");
var _common2 = require("@kbn/spaces-plugin/common");
var _std = require("@kbn/std");
var _aggregated_transactions = require("../../../../../common/aggregated_transactions");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _apm = require("../../../../../common/es_fields/apm");
var _event_outcome = require("../../../../../common/event_outcome");
var _apm_rule_types = require("../../../../../common/rules/apm_rule_types");
var _schema = require("../../../../../common/rules/schema");
var _environment_query = require("../../../../../common/utils/environment_query");
var _formatters2 = require("../../../../../common/utils/formatters");
var _transactions = require("../../../../lib/helpers/transactions");
var _action_variables = require("../../action_variables");
var _alerting_es_client = require("../../alerting_es_client");
var _register_apm_rule_types = require("../../register_apm_rule_types");
var _get_service_group_fields = require("../get_service_group_fields");
var _get_groupby_terms = require("../utils/get_groupby_terms");
var _get_groupby_action_variables = require("../utils/get_groupby_action_variables");
var _get_all_groupby_fields = require("../../../../../common/rules/get_all_groupby_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleTypeConfig = _apm_rule_types.RULE_TYPES_CONFIG[_ruleDataUtils.ApmRuleType.TransactionErrorRate];
const transactionErrorRateActionVariables = [_action_variables.apmActionVariables.alertDetailsUrl, _action_variables.apmActionVariables.environment, _action_variables.apmActionVariables.interval, _action_variables.apmActionVariables.reason, _action_variables.apmActionVariables.serviceName, _action_variables.apmActionVariables.threshold, _action_variables.apmActionVariables.transactionName, _action_variables.apmActionVariables.transactionType, _action_variables.apmActionVariables.triggerValue, _action_variables.apmActionVariables.viewInAppUrl];
exports.transactionErrorRateActionVariables = transactionErrorRateActionVariables;
function registerTransactionErrorRateRuleType({
  alerting,
  alertsLocator,
  apmConfig,
  basePath,
  getApmIndices,
  logger,
  ruleDataClient
}) {
  const createLifecycleRuleType = (0, _server3.createLifecycleRuleTypeFactory)({
    ruleDataClient,
    logger
  });
  alerting.registerType(createLifecycleRuleType({
    id: _ruleDataUtils.ApmRuleType.TransactionErrorRate,
    name: ruleTypeConfig.name,
    actionGroups: ruleTypeConfig.actionGroups,
    defaultActionGroupId: ruleTypeConfig.defaultActionGroupId,
    validate: {
      params: _schema.transactionErrorRateParamsSchema
    },
    actionVariables: {
      context: transactionErrorRateActionVariables
    },
    category: _server.DEFAULT_APP_CATEGORIES.observability.id,
    producer: _apm_rule_types.APM_SERVER_FEATURE_ID,
    minimumLicenseRequired: 'basic',
    isExportable: true,
    executor: async ({
      services,
      spaceId,
      params: ruleParams,
      startedAt,
      getTimeRange
    }) => {
      var _ruleParams$searchCon, _ruleParams$searchCon2, _ruleParams$searchCon3, _ruleParams$searchCon4;
      const allGroupByFields = (0, _get_all_groupby_fields.getAllGroupByFields)(_ruleDataUtils.ApmRuleType.TransactionErrorRate, ruleParams.groupBy);
      const {
        getAlertUuid,
        getAlertStartedDate,
        savedObjectsClient,
        scopedClusterClient
      } = services;
      const indices = await getApmIndices(savedObjectsClient);

      // only query transaction events when set to 'never',
      // to prevent (likely) unnecessary blocking request
      // in rule execution
      const searchAggregatedTransactions = apmConfig.searchAggregatedTransactions !== _aggregated_transactions.SearchAggregatedTransactionSetting.never;
      const index = searchAggregatedTransactions ? indices.metric : indices.transaction;
      const termFilterQuery = !((_ruleParams$searchCon = ruleParams.searchConfiguration) !== null && _ruleParams$searchCon !== void 0 && (_ruleParams$searchCon2 = _ruleParams$searchCon.query) !== null && _ruleParams$searchCon2 !== void 0 && _ruleParams$searchCon2.query) ? [...(0, _server2.termQuery)(_apm.SERVICE_NAME, ruleParams.serviceName, {
        queryEmptyString: false
      }), ...(0, _server2.termQuery)(_apm.TRANSACTION_TYPE, ruleParams.transactionType, {
        queryEmptyString: false
      }), ...(0, _server2.termQuery)(_apm.TRANSACTION_NAME, ruleParams.transactionName, {
        queryEmptyString: false
      }), ...(0, _environment_query.environmentQuery)(ruleParams.environment)] : [];
      const {
        dateStart
      } = getTimeRange(`${ruleParams.windowSize}${ruleParams.windowUnit}`);
      const searchParams = {
        index,
        body: {
          track_total_hits: false,
          size: 0,
          query: {
            bool: {
              filter: [{
                range: {
                  '@timestamp': {
                    gte: dateStart
                  }
                }
              }, ...(0, _transactions.getBackwardCompatibleDocumentTypeFilter)(searchAggregatedTransactions), {
                terms: {
                  [_apm.EVENT_OUTCOME]: [_event_outcome.EventOutcome.failure, _event_outcome.EventOutcome.success]
                }
              }, ...termFilterQuery, ...(0, _server2.getParsedFilterQuery)((_ruleParams$searchCon3 = ruleParams.searchConfiguration) === null || _ruleParams$searchCon3 === void 0 ? void 0 : (_ruleParams$searchCon4 = _ruleParams$searchCon3.query) === null || _ruleParams$searchCon4 === void 0 ? void 0 : _ruleParams$searchCon4.query)]
            }
          },
          aggs: {
            series: {
              multi_terms: {
                terms: [...(0, _get_groupby_terms.getGroupByTerms)(allGroupByFields)],
                size: 1000,
                order: {
                  _count: 'desc'
                }
              },
              aggs: {
                outcomes: {
                  terms: {
                    field: _apm.EVENT_OUTCOME
                  },
                  aggs: (0, _get_service_group_fields.getServiceGroupFieldsAgg)()
                }
              }
            }
          }
        }
      };
      const response = await (0, _alerting_es_client.alertingEsClient)({
        scopedClusterClient,
        params: searchParams
      });
      if (!response.aggregations) {
        return {
          state: {}
        };
      }
      const results = [];
      for (const bucket of response.aggregations.series.buckets) {
        var _failedOutcomeBucket$, _bucket$outcomes$buck, _bucket$outcomes$buck2;
        const groupByFields = bucket.key.reduce((obj, bucketKey, bucketIndex) => {
          obj[allGroupByFields[bucketIndex]] = bucketKey;
          return obj;
        }, {});
        const bucketKey = bucket.key;
        const failedOutcomeBucket = bucket.outcomes.buckets.find(outcomeBucket => outcomeBucket.key === _event_outcome.EventOutcome.failure);
        const failed = (_failedOutcomeBucket$ = failedOutcomeBucket === null || failedOutcomeBucket === void 0 ? void 0 : failedOutcomeBucket.doc_count) !== null && _failedOutcomeBucket$ !== void 0 ? _failedOutcomeBucket$ : 0;
        const succesful = (_bucket$outcomes$buck = (_bucket$outcomes$buck2 = bucket.outcomes.buckets.find(outcomeBucket => outcomeBucket.key === _event_outcome.EventOutcome.success)) === null || _bucket$outcomes$buck2 === void 0 ? void 0 : _bucket$outcomes$buck2.doc_count) !== null && _bucket$outcomes$buck !== void 0 ? _bucket$outcomes$buck : 0;
        const errorRate = failed / (failed + succesful) * 100;
        if (errorRate >= ruleParams.threshold) {
          results.push({
            errorRate,
            sourceFields: (0, _get_service_group_fields.getServiceGroupFields)(failedOutcomeBucket),
            groupByFields,
            bucketKey
          });
        }
      }
      await (0, _std.asyncForEach)(results, async result => {
        var _getEnvironmentEsFiel, _getAlertStartedDate;
        const {
          errorRate,
          sourceFields,
          groupByFields,
          bucketKey
        } = result;
        const alertId = bucketKey.join('_');
        const reasonMessage = (0, _apm_rule_types.formatTransactionErrorRateReason)({
          threshold: ruleParams.threshold,
          measured: errorRate,
          asPercent: _formatters.asPercent,
          windowSize: ruleParams.windowSize,
          windowUnit: ruleParams.windowUnit,
          groupByFields
        });
        const alert = services.alertWithLifecycle({
          id: alertId,
          fields: {
            [_apm.TRANSACTION_NAME]: ruleParams.transactionName,
            [_apm.PROCESSOR_EVENT]: _common.ProcessorEvent.transaction,
            [_ruleDataUtils.ALERT_EVALUATION_VALUE]: errorRate,
            [_ruleDataUtils.ALERT_EVALUATION_THRESHOLD]: ruleParams.threshold,
            [_ruleDataUtils.ALERT_REASON]: reasonMessage,
            ...sourceFields,
            ...groupByFields
          }
        });
        const relativeViewInAppUrl = (0, _formatters2.getAlertUrlTransaction)(groupByFields[_apm.SERVICE_NAME], (_getEnvironmentEsFiel = (0, _environment_filter_values.getEnvironmentEsField)(groupByFields[_apm.SERVICE_ENVIRONMENT])) === null || _getEnvironmentEsFiel === void 0 ? void 0 : _getEnvironmentEsFiel[_apm.SERVICE_ENVIRONMENT], groupByFields[_apm.TRANSACTION_TYPE]);
        const viewInAppUrl = (0, _common2.addSpaceIdToPath)(basePath.publicBaseUrl, spaceId, relativeViewInAppUrl);
        const indexedStartedAt = (_getAlertStartedDate = getAlertStartedDate(alertId)) !== null && _getAlertStartedDate !== void 0 ? _getAlertStartedDate : startedAt.toISOString();
        const alertUuid = getAlertUuid(alertId);
        const alertDetailsUrl = await (0, _common.getAlertUrl)(alertUuid, spaceId, indexedStartedAt, alertsLocator, basePath.publicBaseUrl);
        const groupByActionVariables = (0, _get_groupby_action_variables.getGroupByActionVariables)(groupByFields);
        alert.scheduleActions(ruleTypeConfig.defaultActionGroupId, {
          alertDetailsUrl,
          interval: (0, _common.formatDurationFromTimeUnitChar)(ruleParams.windowSize, ruleParams.windowUnit),
          reason: reasonMessage,
          threshold: ruleParams.threshold,
          transactionName: ruleParams.transactionName,
          triggerValue: (0, _formatters2.asDecimalOrInteger)(errorRate),
          viewInAppUrl,
          ...groupByActionVariables
        });
      });
      return {
        state: {}
      };
    },
    alerts: _register_apm_rule_types.ApmRuleTypeAlertDefinition,
    getViewInAppRelativeUrl: ({
      rule
    }) => _common.observabilityPaths.ruleDetails(rule.id)
  }));
}