"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConfigForDocumentType = getConfigForDocumentType;
exports.getProcessorEventForDocumentType = getProcessorEventForDocumentType;
var _common = require("@kbn/observability-plugin/common");
var _document_type = require("../../../../common/document_type");
var _apm = require("../../../../common/es_fields/apm");
var _rollup = require("../../../../common/rollup");
var _term_query = require("../../../../common/utils/term_query");
var _get_is_using_service_destination_metrics = require("../spans/get_is_using_service_destination_metrics");
var _transactions = require("../transactions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultRollupIntervals = [_rollup.RollupInterval.OneMinute, _rollup.RollupInterval.TenMinutes, _rollup.RollupInterval.SixtyMinutes];
function getDefaultFilter(metricsetName, rollupInterval) {
  return [...(0, _term_query.termQuery)(_apm.METRICSET_NAME, metricsetName), ...(0, _term_query.termQuery)(_apm.METRICSET_INTERVAL, rollupInterval)];
}
const documentTypeConfigMap = {
  [_document_type.ApmDocumentType.ServiceTransactionMetric]: {
    processorEvent: _common.ProcessorEvent.metric,
    getQuery: rollupInterval => ({
      bool: {
        filter: getDefaultFilter('service_transaction', rollupInterval)
      }
    }),
    rollupIntervals: defaultRollupIntervals
  },
  [_document_type.ApmDocumentType.ServiceSummaryMetric]: {
    processorEvent: _common.ProcessorEvent.metric,
    getQuery: rollupInterval => ({
      bool: {
        filter: getDefaultFilter('service_summary', rollupInterval)
      }
    }),
    rollupIntervals: defaultRollupIntervals
  },
  [_document_type.ApmDocumentType.TransactionMetric]: {
    processorEvent: _common.ProcessorEvent.metric,
    getQuery: rollupInterval => ({
      bool: {
        filter: rollupInterval === _rollup.RollupInterval.OneMinute ? (0, _transactions.getBackwardCompatibleDocumentTypeFilter)(true) : getDefaultFilter('transaction', rollupInterval)
      }
    }),
    rollupIntervals: defaultRollupIntervals
  },
  [_document_type.ApmDocumentType.TransactionEvent]: {
    processorEvent: _common.ProcessorEvent.transaction,
    rollupIntervals: [_rollup.RollupInterval.None]
  },
  [_document_type.ApmDocumentType.ServiceDestinationMetric]: {
    processorEvent: _common.ProcessorEvent.metric,
    rollupIntervals: defaultRollupIntervals,
    getQuery: rollupInterval => ({
      bool: {
        filter: rollupInterval === _rollup.RollupInterval.OneMinute ? (0, _get_is_using_service_destination_metrics.getDocumentTypeFilterForServiceDestinationStatistics)(true) : getDefaultFilter('service_destination', rollupInterval)
      }
    })
  },
  [_document_type.ApmDocumentType.ErrorEvent]: {
    processorEvent: _common.ProcessorEvent.error,
    rollupIntervals: [_rollup.RollupInterval.None]
  },
  [_document_type.ApmDocumentType.SpanEvent]: {
    processorEvent: _common.ProcessorEvent.span,
    rollupIntervals: [_rollup.RollupInterval.None]
  }
};
function getConfigForDocumentType(docType) {
  return documentTypeConfigMap[docType];
}
function getProcessorEventForDocumentType(documentType) {
  return getConfigForDocumentType(documentType).processorEvent;
}