"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerGetApmServiceSummaryFunction = registerGetApmServiceSummaryFunction;
var _i18n = require("@kbn/i18n");
var _get_apm_alerts_client = require("../lib/helpers/get_apm_alerts_client");
var _get_ml_client = require("../lib/helpers/get_ml_client");
var _get_apm_service_summary = require("../routes/assistant_functions/get_apm_service_summary");
var _non_empty_string_ref = require("../utils/non_empty_string_ref");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerGetApmServiceSummaryFunction({
  resources,
  apmEventClient,
  registerFunction
}) {
  registerFunction({
    name: 'get_apm_service_summary',
    contexts: ['apm'],
    description: `Gets a summary of a single service, including: the language, service version, 
deployments, the environments, and the infrastructure that it is running in, for instance on how 
many pods, and a list of its downstream dependencies. It also returns active 
alerts and anomalies.`,
    descriptionForUser: _i18n.i18n.translate('xpack.apm.observabilityAiAssistant.functions.registerGetApmServiceSummary.descriptionForUser', {
      defaultMessage: `Gets a summary of a single service, including: the language, service version, 
deployments, the environments, and the infrastructure that it is running in, for instance on how 
many pods, and a list of its downstream dependencies. It also returns active 
alerts and anomalies.`
    }),
    parameters: {
      type: 'object',
      properties: {
        'service.name': {
          ..._non_empty_string_ref.NON_EMPTY_STRING,
          description: 'The name of the service that should be summarized.'
        },
        'service.environment': {
          ..._non_empty_string_ref.NON_EMPTY_STRING,
          description: 'The environment that the service is running in'
        },
        start: {
          ..._non_empty_string_ref.NON_EMPTY_STRING,
          description: 'The start of the time range, in Elasticsearch date math, like `now`.'
        },
        end: {
          ..._non_empty_string_ref.NON_EMPTY_STRING,
          description: 'The end of the time range, in Elasticsearch date math, like `now-24h`.'
        }
      },
      required: ['service.name', 'start', 'end']
    }
  }, async ({
    arguments: args
  }, signal) => {
    const {
      context,
      request,
      plugins,
      logger
    } = resources;
    const [annotationsClient, esClient, apmAlertsClient, mlClient] = await Promise.all([plugins.observability.setup.getScopedAnnotationsClient(context, request), context.core.then(coreContext => coreContext.elasticsearch.client.asCurrentUser), (0, _get_apm_alerts_client.getApmAlertsClient)(resources), (0, _get_ml_client.getMlClient)(resources)]);
    return {
      content: await (0, _get_apm_service_summary.getApmServiceSummary)({
        apmEventClient,
        annotationsClient,
        esClient,
        apmAlertsClient,
        mlClient,
        logger,
        arguments: args
      })
    };
  });
}