"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.javaVariables = exports.javaLineNumbers = exports.javaHighlightLang = exports.java = void 0;
var _shared_hints = require("./shared_hints");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const javaVariables = {
  apmServiceName: 'Delastic.apm.service_name',
  secretToken: 'Delastic.apm.secret_token',
  apmServerUrl: 'Delastic.apm.server_url',
  apmEnvironment: 'Delastic.apm.environment'
};
exports.javaVariables = javaVariables;
const javaHighlightLang = 'java';
exports.javaHighlightLang = javaHighlightLang;
const javaLineNumbers = {
  start: 1,
  highlight: '',
  annotations: {
    2: _shared_hints.serviceNameHint,
    3: _shared_hints.secretTokenHint,
    4: _shared_hints.serverUrlHint,
    5: _shared_hints.serviceEnvironmentHint
  }
};
exports.javaLineNumbers = javaLineNumbers;
const java = `java -javaagent:/path/to/elastic-apm-agent-<version>.jar \\
-${javaVariables.apmServiceName}={{{apmServiceName}}} \\
-${javaVariables.secretToken}={{{secretToken}}} \\
-${javaVariables.apmServerUrl}={{{apmServerUrl}}} \\
-${javaVariables.apmEnvironment}={{{apmEnvironment}}} \\
-Delastic.apm.application_packages=org.example \\
-jar {{{apmServiceName}}}.jar`;
exports.java = java;