"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APM_APP_LOCATOR_ID = exports.APMServiceDetailLocator = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/data-plugin/public");
var _common = require("@kbn/observability-plugin/common");
var _environment_filter_values = require("../../common/environment_filter_values");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const helpersModule = Promise.resolve().then(() => _interopRequireWildcard(require('./helpers')));
const APM_APP_LOCATOR_ID = 'APM_LOCATOR';
exports.APM_APP_LOCATOR_ID = APM_APP_LOCATOR_ID;
class APMServiceDetailLocator {
  constructor(uiSettings) {
    (0, _defineProperty2.default)(this, "id", APM_APP_LOCATOR_ID);
    (0, _defineProperty2.default)(this, "uiSettings", void 0);
    this.uiSettings = uiSettings;
  }
  async getLocation(payload) {
    const {
      getPathForServiceDetail
    } = await helpersModule;
    const defaultTimeRange = this.uiSettings.get(_public.UI_SETTINGS.TIMEPICKER_TIME_DEFAULTS);
    const isComparisonEnabledByDefault = this.uiSettings.get(_common.enableComparisonByDefault);
    const defaultEnvironment = this.uiSettings.get(_common.defaultApmServiceEnvironment, _environment_filter_values.ENVIRONMENT_ALL.value);
    const path = getPathForServiceDetail(payload, {
      ...defaultTimeRange,
      isComparisonEnabledByDefault,
      defaultEnvironment
    });
    return {
      app: 'apm',
      path,
      state: {}
    };
  }
}
exports.APMServiceDetailLocator = APMServiceDetailLocator;