"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProfilingIntegrationSetting = useProfilingIntegrationSetting;
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/observability-plugin/common");
var _apm_feature_flags = require("../../common/apm_feature_flags");
var _use_apm_feature_flag = require("./use_apm_feature_flag");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useProfilingIntegrationSetting() {
  const isProfilingIntegrationFeatureFlagEnabled = (0, _use_apm_feature_flag.useApmFeatureFlag)(_apm_feature_flags.ApmFeatureFlagName.ProfilingIntegrationAvailable);
  const isProfilingIntegrationUiSettingEnabled = (0, _public.useUiSetting)(_common.apmEnableProfilingIntegration);
  return isProfilingIntegrationFeatureFlagEnabled && isProfilingIntegrationUiSettingEnabled;
}