"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataViewId = useDataViewId;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = require("react");
var _data_view_constants = require("../../common/data_view_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDataViewId() {
  const [dataViewId, setDataViewId] = (0, _react.useState)();
  const {
    spaces
  } = (0, _public.useKibana)().services;
  (0, _react.useEffect)(() => {
    const fetchSpaceId = async () => {
      const space = await (spaces === null || spaces === void 0 ? void 0 : spaces.getActiveSpace());
      if (space !== null && space !== void 0 && space.id) {
        setDataViewId((0, _data_view_constants.getDataViewId)(space === null || space === void 0 ? void 0 : space.id));
      }
    };
    fetchSpaceId();
  }, [spaces]);
  return dataViewId;
}